/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.popcraft.bolt.util.BoltComponents;

public class Time {
    private static final int DAYS_IN_YEAR = 365;
    private static final int DAYS_IN_MONTH = 30;
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);

    private Time() {
    }

    public static Component relativeTimestamp(long unixMs, CommandSender sender) {
        return Time.relativeTimestamp(unixMs, sender, Integer.MAX_VALUE);
    }

    public static Component relativeTimestamp(long unixMs, CommandSender sender, int precision) {
        long now = System.currentTimeMillis();
        String timestamp = FORMATTER.withLocale(BoltComponents.getLocaleOf(sender)).format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(unixMs), UTC));
        Duration duration = Duration.of(now - unixMs, ChronoUnit.MILLIS);
        Component ago = Time.agoComponent(duration, sender, precision);
        return BoltComponents.resolveTranslation("time_ago", sender, new TagResolver[]{Placeholder.component((String)"time", (ComponentLike)ago)}).hoverEvent((HoverEventSource)Component.text((String)timestamp));
    }

    private static Component agoComponent(Duration duration, CommandSender sender, int precision) {
        ArrayList<Component> parts = new ArrayList<Component>();
        long days = duration.toDays();
        int hours = duration.toHoursPart();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        if (days >= 365L) {
            long years = Math.floorDiv(days, 365);
            days -= years * 365L;
            parts.add(BoltComponents.resolveTranslation("time_years", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((long)years))}));
        }
        if (days >= 30L && parts.size() < precision) {
            long months = Math.floorDiv(days, 30);
            days -= months * 30L;
            parts.add(BoltComponents.resolveTranslation("time_months", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((long)months))}));
        }
        if (days != 0L && parts.size() < precision) {
            parts.add(BoltComponents.resolveTranslation("time_days", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((long)days))}));
        }
        if (hours != 0 && parts.size() < precision) {
            parts.add(BoltComponents.resolveTranslation("time_hours", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((int)hours))}));
        }
        if (minutes != 0 && parts.size() < precision) {
            parts.add(BoltComponents.resolveTranslation("time_minutes", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((int)minutes))}));
        }
        if (seconds != 0 && parts.size() < precision) {
            parts.add(BoltComponents.resolveTranslation("time_seconds", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((int)seconds))}));
        } else if (parts.isEmpty()) {
            parts.add(BoltComponents.resolveTranslation("time_seconds", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((int)0))}));
        }
        return Component.join((JoinConfiguration)JoinConfiguration.spaces(), parts);
    }
}

