/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.concurrent.Executor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.util.FoliaUtil;

public class SchedulerUtil {
    private SchedulerUtil() {
    }

    public static void schedule(Plugin plugin, CommandSender sender, Runnable runnable) {
        SchedulerUtil.schedule(plugin, sender, runnable, 0L);
    }

    public static void schedule(Plugin plugin, CommandSender sender, Runnable runnable, long delay) {
        if (FoliaUtil.isFolia()) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.getScheduler().execute(plugin, runnable, () -> {}, delay);
            } else if (delay <= 0L) {
                Bukkit.getGlobalRegionScheduler().execute(plugin, runnable);
            } else {
                Bukkit.getGlobalRegionScheduler().runDelayed(plugin, scheduledTask -> runnable.run(), delay);
            }
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(plugin, runnable, delay);
        }
    }

    public static void schedule(Plugin plugin, Location location, Runnable runnable) {
        if (FoliaUtil.isFolia()) {
            Bukkit.getRegionScheduler().execute(plugin, location, runnable);
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(plugin, runnable);
        }
    }

    public static void schedule(Plugin plugin, Runnable runnable, long delay, long interval) {
        if (FoliaUtil.isFolia()) {
            Bukkit.getGlobalRegionScheduler().runAtFixedRate(plugin, scheduledTask -> runnable.run(), delay, interval);
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask(plugin, runnable, delay, interval);
        }
    }

    public static Executor executor(Plugin plugin, CommandSender sender) {
        return command -> SchedulerUtil.schedule(plugin, sender, command);
    }
}

