/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.java.JavaPlugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.compat.EntityTypeMapper;
import org.popcraft.bolt.lang.Strings;
import org.popcraft.bolt.lang.Translator;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.util.BoltComponents;

public final class Protections {
    private Protections() {
    }

    public static Component raw(Protection protection) {
        return Component.text((String)protection.toString());
    }

    public static Component protectionType(Protection protection, CommandSender sender) {
        String protectionType = protection.getType();
        String translationKey = "protection_type_%s".formatted(protectionType);
        if (!Translator.isTranslatable(translationKey, BoltComponents.getLocaleOf(sender))) {
            return Component.text((String)Strings.toTitleCase(protectionType));
        }
        return BoltComponents.resolveTranslation(translationKey, sender, new TagResolver[0]);
    }

    public static Component sourceType(Source source, CommandSender sender) {
        String sourceType = source.getType();
        String translationKey = "source_type_%s".formatted(sourceType);
        if (!Translator.isTranslatable(translationKey, BoltComponents.getLocaleOf(sender))) {
            return Component.text((String)Strings.toTitleCase(sourceType));
        }
        return BoltComponents.resolveTranslation(translationKey, sender, new TagResolver[0]);
    }

    public static Component accessType(String accessType, CommandSender sender) {
        String translationKey = "access_type_%s".formatted(accessType);
        if (!Translator.isTranslatable(translationKey, BoltComponents.getLocaleOf(sender))) {
            return Component.text((String)Strings.toTitleCase(accessType));
        }
        return BoltComponents.resolveTranslation(translationKey, sender, new TagResolver[0]);
    }

    public static Component displayType(Protection protection, CommandSender sender) {
        if (protection instanceof BlockProtection) {
            BlockProtection blockProtection = (BlockProtection)protection;
            World world = Bukkit.getWorld((String)blockProtection.getWorld());
            int x = blockProtection.getX();
            int y = blockProtection.getY();
            int z = blockProtection.getZ();
            if (world == null || !world.isChunkLoaded(x >> 4, z >> 4)) {
                return Protections.displayType(Objects.requireNonNullElse(Material.getMaterial((String)blockProtection.getBlock().toUpperCase()), Material.AIR), sender);
            }
            return Protections.displayType(world.getBlockAt(x, y, z), sender);
        }
        if (protection instanceof EntityProtection) {
            EntityProtection entityProtection = (EntityProtection)protection;
            Entity entity = Bukkit.getServer().getEntity(entityProtection.getId());
            if (entity == null) {
                try {
                    String entityType = entityProtection.getEntity().toUpperCase();
                    return Protections.displayType(EntityType.valueOf((String)EntityTypeMapper.map(entityType)), sender);
                }
                catch (IllegalArgumentException e) {
                    return BoltComponents.resolveTranslation("unknown", sender, new TagResolver[0]);
                }
            }
            return Protections.displayType(entity, sender);
        }
        return BoltComponents.resolveTranslation("unknown", sender, new TagResolver[0]);
    }

    public static Component displayType(Block block, CommandSender sender) {
        Material material = block.getType();
        return Protections.displayType(material, sender);
    }

    private static Component displayType(Material material, CommandSender sender) {
        String blockTranslation;
        String materialNameLower = material.name().toLowerCase();
        String blockTranslationKey = "block_%s".formatted(materialNameLower);
        if (!blockTranslationKey.equals(blockTranslation = BoltComponents.translateRaw(blockTranslationKey, sender))) {
            return Component.text((String)blockTranslation);
        }
        return Component.translatable((Translatable)material);
    }

    public static Component displayType(Entity entity, CommandSender sender) {
        return Protections.displayType(entity.getType(), sender);
    }

    private static Component displayType(EntityType entityType, CommandSender sender) {
        String entityTranslation;
        String entityTypeLower = entityType.name().toLowerCase();
        String entityTranslationKey = "entity_%s".formatted(entityTypeLower);
        if (!entityTranslationKey.equals(entityTranslation = BoltComponents.translateRaw(entityTranslationKey, sender))) {
            return Component.text((String)entityTranslation);
        }
        return Component.translatable((Translatable)entityType);
    }

    public static Component accessList(Map<String, String> accessMap, CommandSender sender) {
        if (accessMap == null || accessMap.isEmpty()) {
            return Component.empty();
        }
        ArrayList<Component> list = new ArrayList<Component>();
        for (Map.Entry<String, String> accessEntry : accessMap.entrySet()) {
            String entry = accessEntry.getKey();
            String access = accessEntry.getValue();
            Source source = Source.parse(entry);
            BoltPlugin plugin = (BoltPlugin)JavaPlugin.getPlugin(BoltPlugin.class);
            String subject = source.getType().equals(source.getIdentifier()) ? Strings.toTitleCase(source.getType()) : plugin.getSourceTransformer(source.getType()).unTransformIdentifier(source.getIdentifier());
            if (plugin.getDefaultAccessType().equals(access)) {
                list.add(BoltComponents.resolveTranslation("access_list_entry_default", sender, new TagResolver[]{Placeholder.component((String)"source_identifier", (ComponentLike)Component.text((String)subject)), Placeholder.component((String)"source_type", (ComponentLike)Protections.sourceType(source, sender)), Placeholder.component((String)"access_type", (ComponentLike)Protections.accessType(access, sender))}));
                continue;
            }
            list.add(BoltComponents.resolveTranslation("access_list_entry", sender, new TagResolver[]{Placeholder.component((String)"source_identifier", (ComponentLike)Component.text((String)subject)), Placeholder.component((String)"source_type", (ComponentLike)Protections.sourceType(source, sender)), Placeholder.component((String)"access_type", (ComponentLike)Protections.accessType(access, sender))}));
        }
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), list);
    }
}

