/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.profile.PlayerProfile;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.data.Profile;
import org.popcraft.bolt.data.ProfileCache;
import org.popcraft.bolt.data.SimpleProfileCache;

public final class Profiles {
    private static final Set<UUID> KNOWN_NULL_LOOKUPS_BY_UUID = ConcurrentHashMap.newKeySet();
    private static final Set<String> KNOWN_NULL_LOOKUPS_BY_NAME = ConcurrentHashMap.newKeySet();
    private static final String NIL_UUID_STRING = "00000000-0000-0000-0000-000000000000";
    public static final UUID NIL_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final int MAX_NAME_LENGTH = 16;

    private Profiles() {
    }

    public static Profile findProfileByName(String name) {
        if (name == null || name.isEmpty() || NIL_UUID_STRING.equals(name)) {
            return SimpleProfileCache.EMPTY_PROFILE;
        }
        ProfileCache profileCache = ((BoltPlugin)JavaPlugin.getPlugin(BoltPlugin.class)).getProfileCache();
        try {
            return profileCache.getProfile(UUID.fromString(name));
        }
        catch (IllegalArgumentException e) {
            Profile cached = profileCache.getProfile(name);
            if (cached.complete()) {
                return cached;
            }
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayerIfCached((String)name);
            if (offlinePlayer != null) {
                profileCache.add(offlinePlayer.getUniqueId(), offlinePlayer.getName());
            }
            return profileCache.getProfile(name);
        }
    }

    public static CompletableFuture<Profile> lookupProfileByName(String name) {
        PlayerProfile playerProfile;
        if (name == null || name.isEmpty() || NIL_UUID_STRING.equals(name) || name.length() > 16 || KNOWN_NULL_LOOKUPS_BY_NAME.contains(name)) {
            return CompletableFuture.completedFuture(SimpleProfileCache.EMPTY_PROFILE);
        }
        try {
            playerProfile = Bukkit.createPlayerProfile((UUID)NIL_UUID, (String)name);
        }
        catch (IllegalArgumentException ignored2) {
            return CompletableFuture.completedFuture(SimpleProfileCache.EMPTY_PROFILE);
        }
        CompletableFuture updatedProfile = playerProfile.update();
        ProfileCache profileCache = ((BoltPlugin)JavaPlugin.getPlugin(BoltPlugin.class)).getProfileCache();
        updatedProfile.thenAccept(profile -> {
            if (profile.isComplete()) {
                profileCache.add(profile.getUniqueId(), profile.getName());
            } else {
                KNOWN_NULL_LOOKUPS_BY_NAME.add(name);
            }
        });
        return ((CompletableFuture)((CompletableFuture)updatedProfile.thenApply(PlayerProfile::getUniqueId)).thenApply(profileCache::getProfile)).exceptionally(ignored -> SimpleProfileCache.EMPTY_PROFILE);
    }

    public static CompletableFuture<Profile> findOrLookupProfileByName(String name) {
        Profile found = Profiles.findProfileByName(name);
        if (found.complete()) {
            return CompletableFuture.completedFuture(found);
        }
        return Profiles.lookupProfileByName(name);
    }

    public static CompletableFuture<Collection<Profile>> findOrLookupProfilesByNames(Collection<String> names) {
        CompletableFuture<Collection<Profile>> profilesFuture = new CompletableFuture<Collection<Profile>>();
        ArrayList profileFutures = new ArrayList();
        names.forEach(name -> profileFutures.add(Profiles.findOrLookupProfileByName(name)));
        CompletableFuture.allOf(profileFutures.toArray(new CompletableFuture[0])).thenRun(() -> {
            ArrayList profiles = new ArrayList();
            profileFutures.forEach(profileFuture -> profiles.add((Profile)profileFuture.join()));
            profilesFuture.complete(profiles);
        });
        return profilesFuture;
    }

    public static Profile findProfileByUniqueId(UUID uuid) {
        if (uuid == null || NIL_UUID.equals(uuid)) {
            return SimpleProfileCache.EMPTY_PROFILE;
        }
        ProfileCache profileCache = ((BoltPlugin)JavaPlugin.getPlugin(BoltPlugin.class)).getProfileCache();
        return profileCache.getProfile(uuid);
    }

    public static CompletableFuture<Profile> lookupProfileByUniqueId(UUID uuid) {
        PlayerProfile playerProfile;
        if (uuid == null || NIL_UUID.equals(uuid) || KNOWN_NULL_LOOKUPS_BY_UUID.contains(uuid)) {
            return CompletableFuture.completedFuture(SimpleProfileCache.EMPTY_PROFILE);
        }
        try {
            playerProfile = Bukkit.createPlayerProfile((UUID)uuid, (String)"");
        }
        catch (IllegalArgumentException ignored2) {
            return CompletableFuture.completedFuture(SimpleProfileCache.EMPTY_PROFILE);
        }
        CompletableFuture updatedProfile = playerProfile.update();
        ProfileCache profileCache = ((BoltPlugin)JavaPlugin.getPlugin(BoltPlugin.class)).getProfileCache();
        updatedProfile.thenAccept(profile -> {
            if (profile.isComplete()) {
                profileCache.add(profile.getUniqueId(), profile.getName());
            } else {
                KNOWN_NULL_LOOKUPS_BY_UUID.add(uuid);
            }
        });
        return ((CompletableFuture)((CompletableFuture)updatedProfile.thenApply(PlayerProfile::getName)).thenApply(profileCache::getProfile)).exceptionally(ignored -> SimpleProfileCache.EMPTY_PROFILE);
    }

    public static CompletableFuture<Profile> findOrLookupProfileByUniqueId(UUID uuid) {
        Profile found = Profiles.findProfileByUniqueId(uuid);
        if (found.complete()) {
            return CompletableFuture.completedFuture(found);
        }
        return Profiles.lookupProfileByUniqueId(uuid);
    }

    public static CompletableFuture<Collection<Profile>> findOrLookupProfilesByUniqueIds(Collection<UUID> uuids) {
        CompletableFuture<Collection<Profile>> profilesFuture = new CompletableFuture<Collection<Profile>>();
        ArrayList profileFutures = new ArrayList();
        uuids.forEach(uuid -> profileFutures.add(Profiles.findOrLookupProfileByUniqueId(uuid)));
        CompletableFuture.allOf(profileFutures.toArray(new CompletableFuture[0])).thenRun(() -> {
            ArrayList profiles = new ArrayList();
            profileFutures.forEach(profileFuture -> profiles.add((Profile)profileFuture.join()));
            profilesFuture.complete(profiles);
        });
        return profilesFuture;
    }
}

