/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.data.Profile;
import org.popcraft.bolt.lang.Translator;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.Protections;
import org.popcraft.bolt.util.Time;

public class Pagination {
    private static final int RESULTS_PER_PAGE = 4;
    private static final int PAGES_BEFORE_AND_AFTER = 4;

    private Pagination() {
    }

    public static void runPage(BoltPlugin plugin, CommandSender sender, List<Protection> protections, int page) {
        int skip = 4 * page;
        boolean newFindFormat = Translator.isTranslated("find_header_new", BoltComponents.getLocaleOf(sender));
        int total = protections.size();
        int totalPages = Math.max(0, (int)Math.ceil((double)total / 4.0) - 1);
        if (newFindFormat) {
            BoltComponents.sendMessage(sender, "find_header_new", new TagResolver[]{Placeholder.component((String)"first", (ComponentLike)Component.text((int)(4 * page + 1))), Placeholder.component((String)"last", (ComponentLike)Component.text((int)Math.min(4 * (page + 1), total))), Placeholder.component((String)"count", (ComponentLike)Component.text((int)total))});
        } else {
            BoltComponents.sendMessage(sender, "find_header", new TagResolver[0]);
        }
        AtomicInteger displayed = new AtomicInteger();
        protections.stream().skip(skip).limit(4L).forEach(protection -> {
            Protection protection2 = protection;
            Objects.requireNonNull(protection2);
            Protection selector0$temp = protection2;
            int index$1 = 0;
            Location location = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockProtection.class, EntityProtection.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BlockProtection block = (BlockProtection)selector0$temp;
                    yield new Location(plugin.getServer().getWorld(block.getWorld()), (double)block.getX() + 0.5, (double)block.getY(), (double)block.getZ() + 0.5);
                }
                case 1 -> {
                    EntityProtection entityProtection = (EntityProtection)selector0$temp;
                    Entity entity = plugin.getServer().getEntity(entityProtection.getId());
                    if (entity == null) {
                        yield null;
                    }
                    yield entity.getLocation();
                }
            };
            Profile profile = Profiles.findProfileByUniqueId(protection.getOwner());
            Component name = Optional.ofNullable(profile.name()).map(Component::text).orElse(BoltComponents.resolveTranslation("unknown", sender, new TagResolver[0]));
            if (location == null) {
                BoltComponents.sendMessage(sender, "find_result_unknown", new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, sender)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, sender)), Placeholder.component((String)"player", (ComponentLike)name), Placeholder.component((String)"time", (ComponentLike)Time.relativeTimestamp(protection.getCreated(), sender, 1))});
            } else {
                Player player2;
                Location playerLocation;
                ClickEvent teleport = plugin.getCallbackManager().registerPlayerOnly(player -> player.teleportAsync(location));
                ArrayList<Component> hoverInfo = new ArrayList<Component>();
                if (sender instanceof Player && Objects.equals((playerLocation = (player2 = (Player)sender).getLocation()).getWorld(), location.getWorld())) {
                    int distance = (int)playerLocation.distance(location);
                    hoverInfo.add(BoltComponents.resolveTranslation("find_distance", sender, new TagResolver[]{Placeholder.component((String)"number", (ComponentLike)Component.text((int)distance))}));
                }
                hoverInfo.add(BoltComponents.resolveTranslation("find_teleport", sender, new TagResolver[0]));
                BoltComponents.sendMessage(sender, "find_result", new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, sender)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, sender)), Placeholder.component((String)"player", (ComponentLike)name), Placeholder.component((String)"time", (ComponentLike)Time.relativeTimestamp(protection.getCreated(), sender, 1)), Placeholder.component((String)"world", (ComponentLike)Component.text((String)Objects.requireNonNull(location.getWorld()).getName())), Placeholder.component((String)"x", (ComponentLike)Component.text((int)location.getBlockX())), Placeholder.component((String)"y", (ComponentLike)Component.text((int)location.getBlockY())), Placeholder.component((String)"z", (ComponentLike)Component.text((int)location.getBlockZ())), Placeholder.styling((String)"command", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{teleport, HoverEvent.showText((Component)Component.join((JoinConfiguration)JoinConfiguration.newlines(), hoverInfo))})});
            }
            displayed.incrementAndGet();
        });
        IntFunction<ClickEvent> pageCallback = newPage -> plugin.getCallbackManager().register(newSender -> Pagination.runPage(plugin, newSender, protections, newPage));
        int numberDisplayed = displayed.get();
        if (numberDisplayed == 0) {
            BoltComponents.sendMessage(sender, "find_none", new TagResolver[0]);
        } else if (newFindFormat) {
            TextComponent pages = Component.empty();
            int firstPage = Math.max(0, page - 4);
            int lastPage = Math.min(page + 4, totalPages);
            pages = pages.append(BoltComponents.resolveTranslation(firstPage == page ? "find_next_new_page_current" : "find_next_new_page_other", sender, new TagResolver[]{Placeholder.component((String)"page", (ComponentLike)Component.text((int)(firstPage + 1)).clickEvent(pageCallback.apply(firstPage)))}));
            for (int p = firstPage + 1; p <= lastPage; ++p) {
                pages = pages.append(BoltComponents.resolveTranslation("find_next_new_page_separator", sender, new TagResolver[0]));
                pages = pages.append(BoltComponents.resolveTranslation(p == page ? "find_next_new_page_current" : "find_next_new_page_other", sender, new TagResolver[]{Placeholder.component((String)"page", (ComponentLike)Component.text((int)(p + 1)).clickEvent(pageCallback.apply(p)))}));
            }
            BoltComponents.sendMessage(sender, "find_next_new", new TagResolver[]{Placeholder.component((String)"pages", (ComponentLike)pages), Placeholder.component((String)"page", (ComponentLike)BoltComponents.resolveTranslation(totalPages == page ? "find_next_new_page_current" : "find_next_new_page_other", sender, new TagResolver[]{Placeholder.component((String)"page", (ComponentLike)Component.text((int)(totalPages + 1)).clickEvent(pageCallback.apply(totalPages)))}))});
        } else if (numberDisplayed == 4) {
            BoltComponents.sendClickableMessage(sender, "find_next", pageCallback.apply(page + 1), new TagResolver[0]);
        }
    }
}

