/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;

public class FoliaUtil {
    private static final boolean CONFIG_EXISTS = FoliaUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");

    private FoliaUtil() {
    }

    public static boolean isFolia() {
        return CONFIG_EXISTS;
    }

    public static Collection<Entity> getNearbyEntities(Block block, BoundingBox boundingBox, Predicate<Entity> filter) {
        World world = block.getWorld();
        if (FoliaUtil.isFolia()) {
            int minChunkX = boundingBox.getMin().getBlockX() >> 4;
            int maxChunkX = boundingBox.getMax().getBlockX() >> 4;
            int minChunkZ = boundingBox.getMin().getBlockZ() >> 4;
            int maxChunkZ = boundingBox.getMax().getBlockZ() >> 4;
            ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    Chunk chunk;
                    if (!world.isChunkLoaded(chunkX, chunkZ) || !Bukkit.getServer().isOwnedByCurrentRegion(world, chunkX, chunkZ) || !(chunk = world.getChunkAt(chunkX, chunkZ)).isEntitiesLoaded()) continue;
                    for (Entity entity : chunk.getEntities()) {
                        if (filter != null && !filter.test(entity) || !boundingBox.overlaps(entity.getBoundingBox())) continue;
                        nearbyEntities.add(entity);
                    }
                }
            }
            return nearbyEntities;
        }
        return world.getNearbyEntities(boundingBox, filter);
    }

    private static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

