/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceResolver;
import org.popcraft.bolt.source.SourceTypeResolver;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.SchedulerUtil;

public final class Doors {
    private static final SourceResolver DOOR_SOURCE_RESOLVER = new SourceTypeResolver(Source.of("door"));
    private static final Map<BlockLocation, Integer> CLOSING = new ConcurrentHashMap<BlockLocation, Integer>();
    private static final Set<PlayerInteractEvent> SELF_FIRED_EVENTS = ConcurrentHashMap.newKeySet();
    private static final Tag<Material> MOB_INTERACTABLE_DOORS = Bukkit.getServer().getTag("blocks", NamespacedKey.minecraft((String)"mob_interactable_doors"), Material.class);
    private static final Function<Material, Boolean> IS_COPPER_DOOR = material -> material.name().contains("COPPER_DOOR") || material.name().contains("COPPER_TRAPDOOR");
    private static final Random RANDOM = new Random();

    private Doors() {
    }

    public static void handlePlayerInteract(BoltPlugin plugin, PlayerInteractEvent event) {
        Protection hingedProtection;
        Block hingedBlock;
        if (SELF_FIRED_EVENTS.remove(event)) {
            return;
        }
        boolean openIron = plugin.isDoorsOpenIron();
        Block block = event.getClickedBlock();
        if (block == null || !Doors.isDoor(block) || !Doors.isDoorOpenable(block, openIron) || Doors.interactionDenied(plugin, event)) {
            return;
        }
        Player player = event.getPlayer();
        HashSet<Block> doors = new HashSet<Block>();
        if (!Doors.isDoorOpenableNormally(block)) {
            doors.add(block);
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(Event.Result.ALLOW);
        }
        if (plugin.isDoorsOpenDouble() && (hingedBlock = Doors.getHingedBlock(block)) != null && Doors.areMatchingDoors(block, hingedBlock) && Doors.isDoor(hingedBlock) && Doors.isDoorOpenable(hingedBlock, openIron) && (hingedProtection = plugin.findProtection(hingedBlock)) != null && plugin.canAccess(hingedProtection, player, "interact")) {
            doors.add(hingedBlock);
        }
        doors.forEach(door -> Doors.toggleDoor(plugin, event, door, true));
        int doorsCloseAfter = plugin.getDoorsCloseAfter();
        if (doorsCloseAfter > 0) {
            doors.add(block);
            doors.forEach(door -> {
                Protection protection = plugin.findProtection((Block)door);
                if (protection == null || !plugin.canAccess(protection, player.getUniqueId(), "auto_close") && !plugin.canAccess(protection, DOOR_SOURCE_RESOLVER, "auto_close")) {
                    return;
                }
                BlockLocation doorBlockLocation = new BlockLocation(door.getWorld().getName(), door.getX(), door.getY(), door.getZ());
                CLOSING.compute(doorBlockLocation, (blockLocation, counter) -> counter == null ? 1 : counter + 1);
                SchedulerUtil.schedule((Plugin)plugin, (CommandSender)player, () -> {
                    int count = CLOSING.compute(doorBlockLocation, (blockLocation, counter) -> counter == null ? 0 : counter - 1);
                    if (count <= 0) {
                        CLOSING.remove(doorBlockLocation);
                        Doors.toggleDoor(plugin, event, door, false);
                    }
                }, (long)doorsCloseAfter * 20L);
            });
        }
    }

    public static boolean interactionDenied(BoltPlugin plugin, PlayerInteractEvent event) {
        boolean ironDoor;
        if (!plugin.getDoorsFixPlugins()) {
            return false;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return false;
        }
        if (event.useInteractedBlock().equals((Object)Event.Result.DENY)) {
            return true;
        }
        boolean leftClick = Action.LEFT_CLICK_BLOCK.equals((Object)event.getAction());
        boolean bl = ironDoor = plugin.isDoorsOpenIron() && !Doors.isDoorOpenableNormally(block);
        if (leftClick || ironDoor) {
            BlockState originalState = block.getState();
            if (ironDoor) {
                block.setType(Material.OAK_DOOR, false);
            }
            PlayerInteractEvent fakeInteract = new PlayerInteractEvent(event.getPlayer(), Action.RIGHT_CLICK_BLOCK, event.getItem(), event.getClickedBlock(), event.getBlockFace());
            SELF_FIRED_EVENTS.add(fakeInteract);
            SchedulerUtil.schedule((Plugin)plugin, block.getLocation(), () -> SELF_FIRED_EVENTS.remove(fakeInteract));
            plugin.getServer().getPluginManager().callEvent((Event)fakeInteract);
            if (ironDoor) {
                block.setBlockData(originalState.getBlockData(), false);
            }
            return fakeInteract.useInteractedBlock().equals((Object)Event.Result.DENY);
        }
        return false;
    }

    public static boolean isDoor(Block block) {
        BlockData blockData = block.getBlockData();
        return blockData instanceof Door || blockData instanceof Gate || blockData instanceof TrapDoor;
    }

    public static Block getHingedBlock(Block block) {
        BlockFace adjacentFace;
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Door)) {
            return null;
        }
        Door door = (Door)blockData;
        switch (door.getFacing()) {
            case NORTH: {
                BlockFace blockFace;
                if (door.getHinge() == Door.Hinge.LEFT) {
                    blockFace = BlockFace.EAST;
                    break;
                }
                blockFace = BlockFace.WEST;
                break;
            }
            case SOUTH: {
                BlockFace blockFace;
                if (door.getHinge() == Door.Hinge.LEFT) {
                    blockFace = BlockFace.WEST;
                    break;
                }
                blockFace = BlockFace.EAST;
                break;
            }
            case EAST: {
                BlockFace blockFace;
                if (door.getHinge() == Door.Hinge.LEFT) {
                    blockFace = BlockFace.SOUTH;
                    break;
                }
                blockFace = BlockFace.NORTH;
                break;
            }
            case WEST: {
                BlockFace blockFace;
                if (door.getHinge() == Door.Hinge.LEFT) {
                    blockFace = BlockFace.NORTH;
                    break;
                }
                blockFace = BlockFace.SOUTH;
                break;
            }
            default: {
                BlockFace blockFace = adjacentFace = null;
            }
        }
        if (adjacentFace == null) {
            return null;
        }
        return block.getRelative(adjacentFace);
    }

    public static boolean areMatchingDoors(Block door, Block hinged) {
        if (IS_COPPER_DOOR.apply(door.getType()).booleanValue() && IS_COPPER_DOOR.apply(hinged.getType()).booleanValue()) {
            return true;
        }
        return hinged.getType().equals((Object)door.getType());
    }

    public static boolean isDoorOpenable(Block block, boolean openIron) {
        Material material = block.getType();
        if (Material.IRON_DOOR.equals((Object)material) || Material.IRON_TRAPDOOR.equals((Object)material)) {
            return openIron;
        }
        if (Tag.DOORS.isTagged((Keyed)material) || Tag.FENCE_GATES.isTagged((Keyed)material) || Tag.TRAPDOORS.isTagged((Keyed)material)) {
            return true;
        }
        return MOB_INTERACTABLE_DOORS != null && MOB_INTERACTABLE_DOORS.isTagged((Keyed)material);
    }

    public static boolean isDoorOpenableNormally(Block block) {
        return Doors.isDoorOpenable(block, false);
    }

    public static void toggleDoor(BoltPlugin plugin, PlayerInteractEvent event, Block block, boolean canOpen) {
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
            if (Event.Result.DENY.equals((Object)event.useInteractedBlock())) {
                return;
            }
            BlockData patt0$temp = block.getBlockData();
            if (!(patt0$temp instanceof Openable)) {
                return;
            }
            Openable openable = (Openable)patt0$temp;
            if (!canOpen && !openable.isOpen()) {
                return;
            }
            openable.setOpen(!openable.isOpen());
            block.setBlockData((BlockData)openable);
            Doors.playDoorSound(block, openable.isOpen());
        });
    }

    private static void playDoorSound(Block block, boolean open) {
        Sound sound;
        Material type = block.getType();
        if (Tag.DOORS.isTagged((Keyed)type)) {
            if (open) {
                sound = switch (type) {
                    case Material.CHERRY_DOOR -> Sound.BLOCK_CHERRY_WOOD_DOOR_OPEN;
                    case Material.BAMBOO_DOOR -> Sound.BLOCK_BAMBOO_WOOD_DOOR_OPEN;
                    case Material.CRIMSON_DOOR, Material.WARPED_DOOR -> Sound.BLOCK_NETHER_WOOD_DOOR_OPEN;
                    case Material.IRON_DOOR -> Sound.BLOCK_IRON_DOOR_OPEN;
                    case Material.COPPER_DOOR, Material.EXPOSED_COPPER_DOOR, Material.WEATHERED_COPPER_DOOR, Material.OXIDIZED_COPPER_DOOR, Material.WAXED_COPPER_DOOR, Material.WAXED_EXPOSED_COPPER_DOOR, Material.WAXED_WEATHERED_COPPER_DOOR, Material.WAXED_OXIDIZED_COPPER_DOOR -> Sound.BLOCK_COPPER_DOOR_OPEN;
                    default -> Sound.BLOCK_WOODEN_DOOR_OPEN;
                };
            } else {
                sound = switch (type) {
                    case Material.CHERRY_DOOR -> Sound.BLOCK_CHERRY_WOOD_DOOR_CLOSE;
                    case Material.BAMBOO_DOOR -> Sound.BLOCK_BAMBOO_WOOD_DOOR_CLOSE;
                    case Material.CRIMSON_DOOR, Material.WARPED_DOOR -> Sound.BLOCK_NETHER_WOOD_DOOR_CLOSE;
                    case Material.IRON_DOOR -> Sound.BLOCK_IRON_DOOR_CLOSE;
                    case Material.COPPER_DOOR, Material.EXPOSED_COPPER_DOOR, Material.WEATHERED_COPPER_DOOR, Material.OXIDIZED_COPPER_DOOR, Material.WAXED_COPPER_DOOR, Material.WAXED_EXPOSED_COPPER_DOOR, Material.WAXED_WEATHERED_COPPER_DOOR, Material.WAXED_OXIDIZED_COPPER_DOOR -> Sound.BLOCK_COPPER_DOOR_CLOSE;
                    default -> Sound.BLOCK_WOODEN_DOOR_CLOSE;
                };
            }
        } else if (Tag.TRAPDOORS.isTagged((Keyed)type)) {
            if (open) {
                sound = switch (type) {
                    case Material.CHERRY_TRAPDOOR -> Sound.BLOCK_CHERRY_WOOD_TRAPDOOR_OPEN;
                    case Material.BAMBOO_TRAPDOOR -> Sound.BLOCK_BAMBOO_WOOD_TRAPDOOR_OPEN;
                    case Material.CRIMSON_TRAPDOOR, Material.WARPED_TRAPDOOR -> Sound.BLOCK_NETHER_WOOD_TRAPDOOR_OPEN;
                    case Material.IRON_TRAPDOOR -> Sound.BLOCK_IRON_TRAPDOOR_OPEN;
                    case Material.COPPER_TRAPDOOR, Material.EXPOSED_COPPER_TRAPDOOR, Material.WEATHERED_COPPER_TRAPDOOR, Material.OXIDIZED_COPPER_TRAPDOOR, Material.WAXED_COPPER_TRAPDOOR, Material.WAXED_EXPOSED_COPPER_TRAPDOOR, Material.WAXED_WEATHERED_COPPER_TRAPDOOR, Material.WAXED_OXIDIZED_COPPER_TRAPDOOR -> Sound.BLOCK_COPPER_TRAPDOOR_OPEN;
                    default -> Sound.BLOCK_WOODEN_TRAPDOOR_OPEN;
                };
            } else {
                sound = switch (type) {
                    case Material.CHERRY_TRAPDOOR -> Sound.BLOCK_CHERRY_WOOD_TRAPDOOR_CLOSE;
                    case Material.BAMBOO_TRAPDOOR -> Sound.BLOCK_BAMBOO_WOOD_TRAPDOOR_CLOSE;
                    case Material.CRIMSON_TRAPDOOR, Material.WARPED_TRAPDOOR -> Sound.BLOCK_NETHER_WOOD_TRAPDOOR_CLOSE;
                    case Material.IRON_TRAPDOOR -> Sound.BLOCK_IRON_TRAPDOOR_CLOSE;
                    case Material.COPPER_TRAPDOOR, Material.EXPOSED_COPPER_TRAPDOOR, Material.WEATHERED_COPPER_TRAPDOOR, Material.OXIDIZED_COPPER_TRAPDOOR, Material.WAXED_COPPER_TRAPDOOR, Material.WAXED_EXPOSED_COPPER_TRAPDOOR, Material.WAXED_WEATHERED_COPPER_TRAPDOOR, Material.WAXED_OXIDIZED_COPPER_TRAPDOOR -> Sound.BLOCK_COPPER_TRAPDOOR_CLOSE;
                    default -> Sound.BLOCK_WOODEN_TRAPDOOR_CLOSE;
                };
            }
        } else if (Tag.FENCE_GATES.isTagged((Keyed)type)) {
            if (open) {
                sound = switch (type) {
                    case Material.CHERRY_FENCE_GATE -> Sound.BLOCK_CHERRY_WOOD_FENCE_GATE_OPEN;
                    case Material.BAMBOO_FENCE_GATE -> Sound.BLOCK_BAMBOO_WOOD_FENCE_GATE_OPEN;
                    case Material.CRIMSON_FENCE_GATE, Material.WARPED_FENCE_GATE -> Sound.BLOCK_NETHER_WOOD_FENCE_GATE_OPEN;
                    default -> Sound.BLOCK_FENCE_GATE_OPEN;
                };
            } else {
                sound = switch (type) {
                    case Material.CHERRY_FENCE_GATE -> Sound.BLOCK_CHERRY_WOOD_FENCE_GATE_CLOSE;
                    case Material.BAMBOO_FENCE_GATE -> Sound.BLOCK_BAMBOO_WOOD_FENCE_GATE_CLOSE;
                    case Material.CRIMSON_FENCE_GATE, Material.WARPED_FENCE_GATE -> Sound.BLOCK_NETHER_WOOD_FENCE_GATE_CLOSE;
                    default -> Sound.BLOCK_FENCE_GATE_CLOSE;
                };
            }
        } else {
            return;
        }
        World world = block.getWorld();
        Location location = block.getLocation();
        world.playSound(location, sound, SoundCategory.BLOCKS, 1.0f, RANDOM.nextFloat() * 0.1f + 0.9f);
    }
}

