/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.popcraft.bolt.Bolt;
import org.popcraft.bolt.source.PlayerSourceResolver;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceResolver;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.Group;

public class BukkitPlayerResolver
implements SourceResolver {
    private final Bolt bolt;
    private final UUID uuid;
    private final BoltPlayer boltPlayer;
    private final Player player;

    public BukkitPlayerResolver(Bolt bolt, UUID uuid) {
        this.bolt = bolt;
        this.uuid = uuid;
        this.boltPlayer = bolt.getBoltPlayer(uuid);
        this.player = Bukkit.getPlayer((UUID)this.boltPlayer.getUuid());
    }

    @Override
    public boolean resolve(Source source) {
        Group group;
        if (this.boltPlayer.sources().contains(source)) {
            return true;
        }
        if ("group".equals(source.getType()) && (group = this.bolt.getStore().loadGroup(source.getIdentifier()).join()) != null && group.getMembers().contains(this.uuid)) {
            return true;
        }
        if (this.player != null && "permission".equals(source.getType()) && this.player.hasPermission(source.getIdentifier())) {
            return true;
        }
        for (PlayerSourceResolver playerSourceResolver : this.bolt.getRegisteredPlayerResolvers()) {
            if (!playerSourceResolver.resolve(source, this.uuid)) continue;
            return true;
        }
        return false;
    }
}

