/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.Mode;

public class BoltPlayer {
    private final UUID uuid;
    private final Map<Source, String> modifications = new HashMap<Source, String>();
    private final Set<Source> sources = new HashSet<Source>();
    private final Set<Mode> modes = new HashSet<Mode>();
    private Action action;
    private Action lastAction;
    private boolean interacted;
    private boolean interactionCancelled;
    private boolean trusting;
    private boolean trustingSilently;
    private boolean lockNil;

    public BoltPlayer(UUID uuid) {
        this.uuid = uuid;
        this.sources.add(Source.player(uuid));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void clearAction() {
        Action triggered = this.action;
        if (triggered != null && !this.hasMode(Mode.PERSIST)) {
            this.lastAction = triggered;
            this.action = null;
        }
    }

    public boolean triggeredAction() {
        return this.lastAction != null;
    }

    public boolean hasInteracted() {
        return this.interacted;
    }

    public boolean isInteractionCancelled() {
        return this.interactionCancelled;
    }

    public void setInteracted(boolean cancelled) {
        this.interacted = true;
        this.interactionCancelled = cancelled;
    }

    public void clearInteraction() {
        this.lastAction = null;
        this.interacted = false;
        this.interactionCancelled = false;
    }

    public boolean hasMode(Mode mode) {
        return this.modes.contains((Object)mode);
    }

    public void toggleMode(Mode mode) {
        if (this.modes.contains((Object)mode)) {
            this.modes.remove((Object)mode);
        } else {
            this.modes.add(mode);
        }
        if (!this.modes.contains((Object)Mode.PERSIST)) {
            this.action = null;
        }
    }

    public Map<Source, String> getModifications() {
        return this.modifications;
    }

    public Map<Source, String> consumeModifications() {
        HashMap<Source, String> modificationsCopy = new HashMap<Source, String>(this.modifications);
        if (!this.modes.contains((Object)Mode.PERSIST)) {
            this.modifications.clear();
        }
        return modificationsCopy;
    }

    public boolean isLockNil() {
        return this.lockNil;
    }

    public void setLockNil(boolean lockNil) {
        this.lockNil = lockNil;
    }

    public void addPassword(String password) {
        this.sources.add(Source.password(password));
    }

    public Set<Source> sources() {
        return this.sources;
    }
}

