/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.util;

import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.popcraft.bolt.lang.Translator;

public final class BoltComponents {
    private static MiniMessage miniMessage;

    private BoltComponents() {
    }

    public static void enable() {
        miniMessage = MiniMessage.miniMessage();
    }

    public static void disable() {
        miniMessage = null;
    }

    private static void sendMessage(CommandSender sender, Component component) {
        if (!component.equals((Object)Component.empty())) {
            sender.sendMessage(component);
        }
    }

    public static void sendMessage(CommandSender sender, String key, TagResolver ... placeholders) {
        BoltComponents.sendMessage(sender, BoltComponents.resolveTranslation(key, sender, placeholders));
    }

    public static void sendMessage(CommandSender sender, String key, boolean actionBar, TagResolver ... placeholders) {
        if (actionBar) {
            sender.sendActionBar(BoltComponents.resolveTranslation(key, sender, placeholders));
        } else {
            BoltComponents.sendMessage(sender, BoltComponents.resolveTranslation(key, sender, placeholders));
        }
    }

    public static void sendClickableMessage(CommandSender sender, String key, ClickEvent clickEvent, TagResolver ... placeholders) {
        BoltComponents.sendMessage(sender, BoltComponents.resolveTranslation(key, sender, placeholders).clickEvent(clickEvent));
    }

    public static Component resolveTranslation(String key, CommandSender sender, TagResolver ... placeholders) {
        return miniMessage.deserialize(BoltComponents.translateRaw(key, sender), placeholders);
    }

    public static String translateRaw(String key, CommandSender sender) {
        return Translator.translate(key, BoltComponents.getLocaleOf(sender));
    }

    public static Locale getLocaleOf(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return player.locale();
        }
        return Locale.ROOT;
    }
}

