/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.source;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.popcraft.bolt.source.SourceType;

public class SourceTypeRegistry {
    private final Map<String, SourceType> sourceTypes = new HashMap<String, SourceType>();

    public void registerSourceType(String sourceType, boolean restricted, boolean unique) {
        this.sourceTypes.put(sourceType, new SourceType(sourceType, restricted, unique));
    }

    public void unregisterAll() {
        this.sourceTypes.clear();
    }

    public Optional<SourceType> getSourceByName(String name) {
        return Optional.ofNullable(this.sourceTypes.get(name));
    }

    public Set<String> names() {
        return new HashSet<String>(this.sourceTypes.keySet());
    }

    public Set<SourceType> sourceTypes() {
        return new HashSet<SourceType>(this.sourceTypes.values());
    }
}

