/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.source;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;

public final class Source {
    private final String type;
    private final String identifier;

    private Source(String type, String identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    private Source(String type) {
        this.type = type;
        this.identifier = type;
    }

    public static Source of(String type, String identifier) {
        return new Source(type, identifier);
    }

    public static Source of(String type) {
        return new Source(type);
    }

    public static Source player(UUID uuid) {
        return new Source("player", uuid.toString());
    }

    public static Source password(String password) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(password.getBytes(StandardCharsets.UTF_8));
            StringBuilder hash = new StringBuilder();
            for (byte b : messageDigest.digest()) {
                hash.append("%02x".formatted(b));
            }
            return new Source("password", hash.toString());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Source parse(String source) {
        if (source == null) {
            return null;
        }
        int split = source.indexOf(58);
        if (split < 0) {
            return new Source(source);
        }
        return new Source(source.substring(0, split), source.substring(split + 1));
    }

    public String getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        return Objects.equals(this.type, source.type) && Objects.equals(this.identifier, source.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.identifier);
    }

    public String toString() {
        return this.type + ":" + this.identifier;
    }
}

