/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.source.SourceTransformer;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Profiles;

public class PlayerSourceTransformer
implements SourceTransformer {
    private final BoltPlugin plugin;

    public PlayerSourceTransformer(BoltPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<String> transformIdentifier(String identifier) {
        return Profiles.findOrLookupProfileByName(identifier).thenApply(profile -> {
            if (profile.uuid() != null) {
                return profile.uuid().toString();
            }
            return null;
        });
    }

    @Override
    public void sendErrorNotFound(String identifier, CommandSender sender) {
        BoltComponents.sendMessage(sender, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)identifier))});
    }

    @Override
    public List<String> completions(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            list.add(player.getName());
        }
        return list;
    }

    @Override
    public String unTransformIdentifier(String identifier) {
        UUID uuid = UUID.fromString(identifier);
        String playerName = Profiles.findProfileByUniqueId(uuid).name();
        return Optional.ofNullable(playerName).orElse(identifier);
    }
}

