/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class VineMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> VINE_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.contains(Material.VINE);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        if (Material.VINE.equals((Object)block.getType())) {
            Set<Block> blocks = this.findVines(block);
            return Match.ofBlocks(blocks);
        }
        HashSet<Block> blocks = new HashSet<Block>();
        for (BlockFace blockFace : VINE_FACES) {
            Block adjacent = block.getRelative(blockFace);
            if (!Material.VINE.equals((Object)adjacent.getType())) continue;
            blocks.add(adjacent);
            blocks.addAll(this.findVines(adjacent));
        }
        return Match.ofBlocks(blocks);
    }

    private Set<Block> findVines(Block vine) {
        HashSet<Block> blocks = new HashSet<Block>();
        Block next = vine.getRelative(BlockFace.DOWN);
        while (Material.VINE.equals((Object)next.getType()) && this.isUnsupported(next)) {
            blocks.add(next);
            next = next.getRelative(BlockFace.DOWN);
        }
        return blocks;
    }

    private boolean isUnsupported(Block vine) {
        BlockData blockData = vine.getBlockData();
        if (blockData instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)blockData;
            for (BlockFace blockFace : multipleFacing.getFaces()) {
                if (!vine.getRelative(blockFace).getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }
}

