/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class UprootMatcher
implements BlockMatcher {
    private static final Set<Material> UPROOT = Set.of(Material.BAMBOO, Material.CACTUS, Material.SUGAR_CANE, Material.TWISTING_VINES, Material.TWISTING_VINES_PLANT, Material.KELP, Material.KELP_PLANT);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(UPROOT::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (UPROOT.contains(block.getType()) || UPROOT.contains(above.getType())) {
            HashSet<Block> blocks = new HashSet<Block>();
            Block next = block.getRelative(BlockFace.UP);
            while (UPROOT.contains(next.getType())) {
                blocks.add(next);
                next = next.getRelative(BlockFace.UP);
            }
            return Match.ofBlocks(blocks);
        }
        return null;
    }
}

