/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class TorchMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARDINAL_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private static final Set<Material> TORCHES = Set.of(Material.TORCH, Material.REDSTONE_TORCH, Material.SOUL_TORCH);
    private static final Set<Material> WALL_TORCHES = Set.of(Material.WALL_TORCH, Material.REDSTONE_WALL_TORCH, Material.SOUL_WALL_TORCH);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> TORCHES.contains(material) || WALL_TORCHES.contains(material));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (TORCHES.contains(above.getType())) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        for (BlockFace blockFace : CARDINAL_FACES) {
            Directional directional;
            BlockData blockData;
            Block adjacent = block.getRelative(blockFace);
            if (!WALL_TORCHES.contains(adjacent.getType()) || !((blockData = adjacent.getBlockData()) instanceof Directional) || !blockFace.equals((Object)(directional = (Directional)blockData).getFacing())) continue;
            return Match.ofBlocks(Collections.singleton(adjacent));
        }
        return null;
    }
}

