/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class TechnicalPistonMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Piston);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled && Material.PISTON_HEAD.equals((Object)block.getType());
    }

    @Override
    public Match findMatch(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof TechnicalPiston) {
            TechnicalPiston technicalPiston = (TechnicalPiston)blockData;
            return Match.ofBlocks(Collections.singleton(block.getRelative(technicalPiston.getFacing().getOppositeFace())));
        }
        return null;
    }
}

