/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class TallGrassMatcher
implements BlockMatcher {
    private static final Set<Material> TALL_GRASS = Set.of(Material.TALL_GRASS, Material.LARGE_FERN, Material.TALL_SEAGRASS);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(TALL_GRASS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        BlockData blockData;
        if (TALL_GRASS.contains(block.getType()) && (blockData = block.getBlockData()) instanceof Bisected) {
            Bisected bisected = (Bisected)blockData;
            Bisected.Half half = bisected.getHalf();
            if (Bisected.Half.BOTTOM.equals((Object)half)) {
                return Match.ofBlocks(Collections.singleton(block.getRelative(BlockFace.UP)));
            }
            return Match.ofBlocks(Collections.singleton(block.getRelative(BlockFace.DOWN)));
        }
        Block above = block.getRelative(BlockFace.UP);
        if (TALL_GRASS.contains(above.getType())) {
            return Match.ofBlocks(List.of(above, above.getRelative(BlockFace.UP)));
        }
        return null;
    }
}

