/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class SwitchMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARTESIAN_FACES = EnumSet.of(BlockFace.NORTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN});
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Switch);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        for (BlockFace blockFace : CARTESIAN_FACES) {
            Switch zwitch;
            Block adjacent = block.getRelative(blockFace);
            BlockData blockData = adjacent.getBlockData();
            if (!(blockData instanceof Switch) || !(FaceAttachable.AttachedFace.CEILING.equals((Object)(zwitch = (Switch)blockData).getAttachedFace()) && BlockFace.DOWN.equals((Object)blockFace) || FaceAttachable.AttachedFace.FLOOR.equals((Object)zwitch.getAttachedFace()) && BlockFace.UP.equals((Object)blockFace)) && !zwitch.getFacing().equals((Object)blockFace)) continue;
            return Match.ofBlocks(Collections.singleton(adjacent));
        }
        return null;
    }
}

