/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.EnumUtil;

public class SmallFlowerMatcher
implements BlockMatcher {
    private static final Material CACTUS_FLOWER = EnumUtil.valueOf(Material.class, "CACTUS_FLOWER").orElse(null);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> Tag.SMALL_FLOWERS.isTagged((Keyed)material) || material.equals((Object)CACTUS_FLOWER));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (Tag.SMALL_FLOWERS.isTagged((Keyed)above.getType()) || above.getType().equals((Object)CACTUS_FLOWER)) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        return null;
    }
}

