/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class SmallDripleafMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.contains(Material.SMALL_DRIPLEAF);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        BlockData blockData;
        if (Material.SMALL_DRIPLEAF.equals((Object)block.getType()) && (blockData = block.getBlockData()) instanceof Bisected) {
            Bisected bisected = (Bisected)blockData;
            Bisected.Half half = bisected.getHalf();
            if (Bisected.Half.BOTTOM.equals((Object)half)) {
                return Match.ofBlocks(Collections.singleton(block.getRelative(BlockFace.UP)));
            }
            return Match.ofBlocks(Collections.singleton(block.getRelative(BlockFace.DOWN)));
        }
        Block above = block.getRelative(BlockFace.UP);
        if (Material.SMALL_DRIPLEAF.equals((Object)above.getType())) {
            return Match.ofBlocks(List.of(above, above.getRelative(BlockFace.UP)));
        }
        return null;
    }
}

