/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Scaffolding;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class ScaffoldingMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> SUPPORT_FACES = EnumSet.of(BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.contains(Material.SCAFFOLDING);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        if (Material.SCAFFOLDING.equals((Object)block.getType()) || Material.SCAFFOLDING.equals((Object)block.getRelative(BlockFace.UP).getType())) {
            HashSet<Block> blocks = new HashSet<Block>();
            this.findScaffolding(blocks, block);
            return Match.ofBlocks(blocks);
        }
        return null;
    }

    private void findScaffolding(Set<Block> scaffolds, Block current) {
        for (BlockFace blockFace : SUPPORT_FACES) {
            Block adjacent = current.getRelative(blockFace);
            BlockData blockData = adjacent.getBlockData();
            if (!(blockData instanceof Scaffolding)) continue;
            Scaffolding adjacentScaffolding = (Scaffolding)blockData;
            if (!BlockFace.UP.equals((Object)blockFace)) {
                blockData = current.getBlockData();
                if (!(blockData instanceof Scaffolding)) continue;
                Scaffolding currentScaffolding = (Scaffolding)blockData;
                if (!adjacentScaffolding.isBottom() || adjacentScaffolding.getDistance() <= currentScaffolding.getDistance()) continue;
            }
            scaffolds.add(adjacent);
            this.findScaffolding(scaffolds, adjacent);
        }
    }
}

