/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class PortalMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARTESIAN_FACES = EnumSet.of(BlockFace.NORTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN});
    private static final EnumSet<BlockFace> X_FACES = EnumSet.of(BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN);
    private static final EnumSet<BlockFace> Z_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.UP, BlockFace.DOWN);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.contains(Material.NETHER_PORTAL);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled && (Material.OBSIDIAN.equals((Object)block.getType()) || Material.NETHER_PORTAL.equals((Object)block.getType()));
    }

    @Override
    public Match findMatch(Block block) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (BlockFace blockFace : CARTESIAN_FACES) {
            BlockData blockData;
            Block adjacent = block.getRelative(blockFace);
            if (!Material.NETHER_PORTAL.equals((Object)adjacent.getType()) || !((blockData = adjacent.getBlockData()) instanceof Orientable)) continue;
            Orientable orientable = (Orientable)blockData;
            blocks.add(adjacent);
            this.findPortal(Axis.X.equals((Object)orientable.getAxis()) ? X_FACES : Z_FACES, blocks, adjacent);
        }
        return Match.ofBlocks(blocks);
    }

    private void findPortal(EnumSet<BlockFace> faces, Set<Block> found, Block current) {
        for (BlockFace blockFace : faces) {
            Block adjacent = current.getRelative(blockFace);
            if (!Material.NETHER_PORTAL.equals((Object)adjacent.getType()) || found.contains(adjacent)) continue;
            found.add(adjacent);
            this.findPortal(faces, found, adjacent);
        }
    }
}

