/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class PointedDripstoneMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof PointedDripstone);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        PointedDripstone pointedDripstone;
        PointedDripstone pointedDripstone2;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof PointedDripstone) {
            PointedDripstone nextDripstone;
            BlockData blockData2;
            PointedDripstone pointedDripstone3 = (PointedDripstone)blockData;
            HashSet<Block> blocks = new HashSet<Block>();
            BlockFace verticalDirection = pointedDripstone3.getVerticalDirection();
            Block next = block.getRelative(verticalDirection);
            while ((blockData2 = next.getBlockData()) instanceof PointedDripstone && verticalDirection.equals((Object)(nextDripstone = (PointedDripstone)blockData2).getVerticalDirection())) {
                blocks.add(next);
                next = next.getRelative(verticalDirection);
            }
            return Match.ofBlocks(blocks);
        }
        Block above = block.getRelative(BlockFace.UP);
        BlockData verticalDirection = above.getBlockData();
        if (verticalDirection instanceof PointedDripstone && BlockFace.UP.equals((Object)(pointedDripstone2 = (PointedDripstone)verticalDirection).getVerticalDirection())) {
            PointedDripstone nextDripstone;
            BlockData blockData3;
            HashSet<Block> blocks = new HashSet<Block>();
            Block next = above;
            while ((blockData3 = next.getBlockData()) instanceof PointedDripstone && BlockFace.UP.equals((Object)(nextDripstone = (PointedDripstone)blockData3).getVerticalDirection())) {
                blocks.add(next);
                next = next.getRelative(BlockFace.UP);
            }
            return Match.ofBlocks(blocks);
        }
        Block below = block.getRelative(BlockFace.DOWN);
        BlockData nextDripstone = below.getBlockData();
        if (nextDripstone instanceof PointedDripstone && BlockFace.DOWN.equals((Object)(pointedDripstone = (PointedDripstone)nextDripstone).getVerticalDirection())) {
            PointedDripstone nextDripstone2;
            BlockData blockData4;
            HashSet<Block> blocks = new HashSet<Block>();
            Block next = below;
            while ((blockData4 = next.getBlockData()) instanceof PointedDripstone && BlockFace.DOWN.equals((Object)(nextDripstone2 = (PointedDripstone)blockData4).getVerticalDirection())) {
                blocks.add(next);
                next = next.getRelative(BlockFace.DOWN);
            }
            return Match.ofBlocks(blocks);
        }
        return null;
    }
}

