/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.EnumUtil;

public class PinkPetalsMatcher
implements BlockMatcher {
    private static final Material LEAF_LITTER = EnumUtil.valueOf(Material.class, "LEAF_LITTER").orElse(null);
    private static final Material WILDFLOWERS = EnumUtil.valueOf(Material.class, "WILDFLOWERS").orElse(null);
    private static final Set<Material> PETALS = new HashSet<Material>(Set.of(Material.PINK_PETALS));
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(PETALS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (PETALS.contains(above.getType())) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        return null;
    }

    static {
        if (LEAF_LITTER != null) {
            PETALS.add(LEAF_LITTER);
        }
        if (WILDFLOWERS != null) {
            PETALS.add(WILDFLOWERS);
        }
    }
}

