/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;
import org.bukkit.util.BoundingBox;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.FoliaUtil;

public class PaintingMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableEntities.contains(EntityType.PAINTING);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        HashSet<Entity> entities = new HashSet<Entity>();
        FoliaUtil.getNearbyEntities(block, block.getBoundingBox().expand(0.5, 0.0, 0.5, 0.5, 0.0, 0.5), Painting.class::isInstance).forEach(entity -> {
            if (entity instanceof Painting) {
                Block max;
                Block min;
                Painting painting = (Painting)entity;
                Art art = painting.getArt();
                int width = art.getBlockWidth();
                int height = art.getBlockHeight();
                if (BlockFace.NORTH.equals((Object)painting.getFacing()) || BlockFace.SOUTH.equals((Object)painting.getFacing())) {
                    Block max2;
                    Block min2 = painting.getLocation().subtract((double)width / 2.0, (double)height / 2.0, 0.0).getBlock().getRelative(painting.getAttachedFace());
                    if (BoundingBox.of((Block)min2, (Block)(max2 = min2.getRelative(width - 1, height - 1, 0))).overlaps(block.getBoundingBox())) {
                        entities.add((Entity)painting);
                    }
                } else if ((BlockFace.WEST.equals((Object)painting.getFacing()) || BlockFace.EAST.equals((Object)painting.getFacing())) && BoundingBox.of((Block)(min = painting.getLocation().subtract(0.0, (double)height / 2.0, (double)width / 2.0).getBlock().getRelative(painting.getAttachedFace())), (Block)(max = min.getRelative(0, height - 1, width - 1))).overlaps(block.getBoundingBox())) {
                    entities.add((Entity)painting);
                }
            }
        });
        return Match.ofEntities(entities);
    }
}

