/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.EnumUtil;

public class MultipleFacingMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARTESIAN_FACES = EnumSet.of(BlockFace.NORTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN});
    private static final Set<Material> MULTIPLE_FACING = new HashSet<Material>(Set.of(Material.SCULK_VEIN, Material.GLOW_LICHEN));
    private static final Material RESIN_CLUMP = EnumUtil.valueOf(Material.class, "RESIN_CLUMP").orElse(null);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(MULTIPLE_FACING::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (BlockFace blockFace : CARTESIAN_FACES) {
            MultipleFacing multipleFacing;
            BlockData blockData;
            Block adjacent = block.getRelative(blockFace);
            if (!MULTIPLE_FACING.contains(adjacent.getType()) || !((blockData = adjacent.getBlockData()) instanceof MultipleFacing) || !(multipleFacing = (MultipleFacing)blockData).getFaces().contains(blockFace.getOppositeFace())) continue;
            blocks.add(adjacent);
        }
        return Match.ofBlocks(blocks);
    }

    static {
        if (RESIN_CLUMP != null) {
            MULTIPLE_FACING.add(RESIN_CLUMP);
        }
    }
}

