/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.EnumUtil;

public class MossCarpetMatcher
implements BlockMatcher {
    private static final Set<Material> MOSS_CARPETS = new HashSet<Material>(Set.of(Material.MOSS_CARPET));
    private static final Material PALE_MOSS_CARPET = EnumUtil.valueOf(Material.class, "PALE_MOSS_CARPET").orElse(null);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(MOSS_CARPETS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (MOSS_CARPETS.contains(above.getType())) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        return null;
    }

    static {
        if (PALE_MOSS_CARPET != null) {
            MOSS_CARPETS.add(PALE_MOSS_CARPET);
        }
    }
}

