/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LeashHitch;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.FoliaUtil;

public class LeashKnotMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableEntities.contains(EntityType.LEASH_KNOT);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled && Tag.FENCES.isTagged((Keyed)block.getType());
    }

    @Override
    public Match findMatch(Block block) {
        return Match.ofEntities(FoliaUtil.getNearbyEntities(block, block.getBoundingBox(), LeashHitch.class::isInstance));
    }
}

