/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class LanternMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Lantern);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Lantern lantern;
        Lantern lantern2;
        Block above = block.getRelative(BlockFace.UP);
        BlockData blockData = above.getBlockData();
        if (blockData instanceof Lantern && !(lantern2 = (Lantern)blockData).isHanging()) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        Block below = block.getRelative(BlockFace.DOWN);
        BlockData blockData2 = below.getBlockData();
        if (blockData2 instanceof Lantern && (lantern = (Lantern)blockData2).isHanging()) {
            return Match.ofBlocks(Collections.singleton(below));
        }
        return null;
    }
}

