/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Ladder;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class LadderMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARDINAL_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Ladder);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        for (BlockFace blockFace : CARDINAL_FACES) {
            Ladder ladder;
            Block wall = block.getRelative(blockFace);
            BlockData blockData = wall.getBlockData();
            if (!(blockData instanceof Ladder) || !blockFace.equals((Object)(ladder = (Ladder)blockData).getFacing())) continue;
            return Match.ofBlocks(Collections.singleton(wall));
        }
        return null;
    }
}

