/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.FoliaUtil;

public class ItemFrameMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableEntities.stream().anyMatch(entityType -> EntityType.ITEM_FRAME.equals(entityType) || EntityType.GLOW_ITEM_FRAME.equals(entityType));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        HashSet<Entity> entities = new HashSet<Entity>();
        FoliaUtil.getNearbyEntities(block, block.getBoundingBox().expand(0.5, 0.5, 0.5, 0.5, 0.5, 0.5), ItemFrame.class::isInstance).forEach(entity -> {
            ItemFrame itemFrame;
            if (entity instanceof ItemFrame && (itemFrame = (ItemFrame)entity).getLocation().getBlock().getRelative(itemFrame.getAttachedFace()).getLocation().equals((Object)block.getLocation())) {
                entities.add((Entity)entity);
            }
        });
        return Match.ofEntities(entities);
    }
}

