/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.EnumUtil;

public class HangingVineMatcher
implements BlockMatcher {
    private static final Set<Material> WEEPING_VINES = Set.of(Material.WEEPING_VINES, Material.WEEPING_VINES_PLANT);
    private static final Material PALE_HANGING_MOSS = EnumUtil.valueOf(Material.class, "PALE_HANGING_MOSS").orElse(null);
    private boolean enabled;

    private boolean isHangingVine(Material material) {
        if (Tag.CAVE_VINES.isTagged((Keyed)material) || WEEPING_VINES.contains(material)) {
            return true;
        }
        return material.equals((Object)PALE_HANGING_MOSS);
    }

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(this::isHangingVine);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block below = block.getRelative(BlockFace.DOWN);
        if (this.isHangingVine(block.getType()) || this.isHangingVine(below.getType())) {
            HashSet<Block> blocks = new HashSet<Block>();
            Block next = block.getRelative(BlockFace.DOWN);
            while (this.isHangingVine(next.getType())) {
                blocks.add(next);
                next = next.getRelative(BlockFace.DOWN);
            }
            return Match.ofBlocks(blocks);
        }
        return null;
    }
}

