/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.util.EnumUtil;

public class GrassMatcher
implements BlockMatcher {
    private static final Material BUSH = EnumUtil.valueOf(Material.class, "BUSH").orElse(null);
    private static final Material FIREFLY_BUSH = EnumUtil.valueOf(Material.class, "FIREFLY_BUSH").orElse(null);
    private static final Material SHORT_DRY_GRASS = EnumUtil.valueOf(Material.class, "SHORT_DRY_GRASS").orElse(null);
    private static final Material TALL_DRY_GRASS = EnumUtil.valueOf(Material.class, "TALL_DRY_GRASS").orElse(null);
    private static final Set<Material> GRASS = new HashSet<Material>(Set.of(Material.SHORT_GRASS, Material.FERN, Material.SEAGRASS, Material.NETHER_SPROUTS, Material.WARPED_ROOTS, Material.CRIMSON_ROOTS));
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(GRASS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (GRASS.contains(above.getType())) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        return null;
    }

    static {
        if (BUSH != null) {
            GRASS.add(BUSH);
        }
        if (FIREFLY_BUSH != null) {
            GRASS.add(FIREFLY_BUSH);
        }
        if (SHORT_DRY_GRASS != null) {
            GRASS.add(SHORT_DRY_GRASS);
        }
        if (TALL_DRY_GRASS != null) {
            GRASS.add(TALL_DRY_GRASS);
        }
    }
}

