/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Fire;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class FireMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> FIRE_FACES = EnumSet.of(BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Fire);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (BlockFace blockFace : FIRE_FACES) {
            Block adjacent = block.getRelative(blockFace);
            BlockData blockData = adjacent.getBlockData();
            if (!(blockData instanceof Fire)) continue;
            Fire fire = (Fire)blockData;
            if ((!BlockFace.UP.equals((Object)blockFace) || !fire.getFaces().isEmpty()) && !fire.getFaces().contains(blockFace.getOppositeFace())) continue;
            blocks.add(adjacent);
        }
        return Match.ofBlocks(blocks);
    }
}

