/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class DoorMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Door);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        HashSet<Block> blocks = new HashSet<Block>();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            if (Bisected.Half.BOTTOM.equals((Object)door.getHalf())) {
                Block upperHalf = block.getRelative(BlockFace.UP);
                if (upperHalf.getBlockData() instanceof Door) {
                    blocks.add(upperHalf);
                }
            } else {
                lowerHalf = block.getRelative(BlockFace.DOWN);
                if (lowerHalf.getBlockData() instanceof Door) {
                    blocks.add(lowerHalf);
                }
            }
        } else {
            lowerHalf = block.getRelative(BlockFace.UP);
            if (lowerHalf.getBlockData() instanceof Door) {
                blocks.add(lowerHalf);
                Block upperHalf = lowerHalf.getRelative(BlockFace.UP);
                if (upperHalf.getBlockData() instanceof Door) {
                    blocks.add(upperHalf);
                }
            }
        }
        return Match.ofBlocks(blocks);
    }
}

