/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.CoralWallFan;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class CoralMatcher
implements BlockMatcher {
    private static final Set<Material> DEAD_CORALS = Set.of(Material.DEAD_BRAIN_CORAL, Material.DEAD_BUBBLE_CORAL, Material.DEAD_FIRE_CORAL, Material.DEAD_HORN_CORAL, Material.DEAD_TUBE_CORAL);
    private static final EnumSet<BlockFace> CARDINAL_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> Tag.CORALS.isTagged((Keyed)material) || DEAD_CORALS.contains(material) || material.createBlockData() instanceof CoralWallFan);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        for (BlockFace blockFace : CARDINAL_FACES) {
            CoralWallFan coralWallFan;
            Block adjacent = block.getRelative(blockFace);
            BlockData blockData = adjacent.getBlockData();
            if (!(blockData instanceof CoralWallFan) || !blockFace.equals((Object)(coralWallFan = (CoralWallFan)blockData).getFacing())) continue;
            return Match.ofBlocks(Collections.singleton(adjacent));
        }
        Block above = block.getRelative(BlockFace.UP);
        if ((Tag.CORALS.isTagged((Keyed)above.getType()) || DEAD_CORALS.contains(above.getType())) && !(above.getBlockData() instanceof CoralWallFan)) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        return null;
    }
}

