/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Cocoa;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class CocoaMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARDINAL_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(arg_0 -> ((Tag)Tag.JUNGLE_LOGS).isTagged(arg_0));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled && Tag.JUNGLE_LOGS.isTagged((Keyed)block.getType());
    }

    @Override
    public Match findMatch(Block block) {
        for (BlockFace blockFace : CARDINAL_FACES) {
            Block wall = block.getRelative(blockFace);
            BlockData blockData = wall.getBlockData();
            if (!(blockData instanceof Cocoa)) continue;
            Cocoa cocoa = (Cocoa)blockData;
            if (!blockFace.getOppositeFace().equals((Object)cocoa.getFacing())) continue;
            return Match.ofBlocks(Collections.singleton(wall));
        }
        return null;
    }
}

