/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class ChorusMatcher
implements BlockMatcher {
    private static final Set<Material> CHORUS = Set.of(Material.CHORUS_PLANT, Material.CHORUS_FLOWER);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(CHORUS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        if (CHORUS.contains(block.getType())) {
            HashSet<Block> blocks = new HashSet<Block>();
            this.findChorus(blocks, block);
            return Match.ofBlocks(blocks);
        }
        Block above = block.getRelative(BlockFace.UP);
        if (CHORUS.contains(above.getType())) {
            HashSet<Block> blocks = new HashSet<Block>();
            this.findChorus(blocks, above);
            return Match.ofBlocks(blocks);
        }
        return null;
    }

    private void findChorus(Set<Block> blocks, Block current) {
        Object object;
        if (Material.CHORUS_FLOWER.equals((Object)current.getType())) {
            blocks.add(current);
        } else if (Material.CHORUS_PLANT.equals((Object)current.getType()) && (object = current.getBlockData()) instanceof MultipleFacing) {
            MultipleFacing multipleFacing = (MultipleFacing)object;
            blocks.add(current);
            for (BlockFace blockFace : multipleFacing.getFaces()) {
                Block next;
                if (BlockFace.DOWN.equals((Object)blockFace) || blocks.contains(next = current.getRelative(blockFace))) continue;
                this.findChorus(blocks, next);
            }
        }
    }
}

