/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class ChestMatcher
implements BlockMatcher {
    private static final Set<Material> CHESTS = new HashSet<Material>(Set.of(Material.CHEST, Material.TRAPPED_CHEST));
    private static final Tag<Material> COPPER_CHESTS = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"copper_chests"), Material.class);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(CHESTS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled && CHESTS.contains(block.getType());
    }

    @Override
    public Match findMatch(Block block) {
        Chest chest;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Chest && !Chest.Type.SINGLE.equals((Object)(chest = (Chest)blockData).getType())) {
            Block adjacent;
            BlockFace adjacentFace;
            switch (chest.getFacing()) {
                case NORTH: {
                    BlockFace blockFace;
                    if (chest.getType() == Chest.Type.LEFT) {
                        blockFace = BlockFace.EAST;
                        break;
                    }
                    blockFace = BlockFace.WEST;
                    break;
                }
                case SOUTH: {
                    BlockFace blockFace;
                    if (chest.getType() == Chest.Type.LEFT) {
                        blockFace = BlockFace.WEST;
                        break;
                    }
                    blockFace = BlockFace.EAST;
                    break;
                }
                case EAST: {
                    BlockFace blockFace;
                    if (chest.getType() == Chest.Type.LEFT) {
                        blockFace = BlockFace.SOUTH;
                        break;
                    }
                    blockFace = BlockFace.NORTH;
                    break;
                }
                case WEST: {
                    BlockFace blockFace;
                    if (chest.getType() == Chest.Type.LEFT) {
                        blockFace = BlockFace.NORTH;
                        break;
                    }
                    blockFace = BlockFace.SOUTH;
                    break;
                }
                default: {
                    BlockFace blockFace = adjacentFace = null;
                }
            }
            if (adjacentFace != null && (adjacent = block.getRelative(adjacentFace)).getBlockData() instanceof Chest) {
                return Match.ofBlocks(Collections.singleton(adjacent));
            }
        }
        return null;
    }

    static {
        if (COPPER_CHESTS != null) {
            CHESTS.addAll(COPPER_CHESTS.getValues());
        }
    }
}

