/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class CakeMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> Material.CAKE.equals(material) || Tag.CANDLE_CAKES.isTagged((Keyed)material));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (Material.CAKE.equals((Object)above.getType()) || Tag.CANDLE_CAKES.isTagged((Keyed)above.getType())) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        return null;
    }
}

