/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class BigDripleafMatcher
implements BlockMatcher {
    private static final Set<Material> BIG_DRIPLEAF_BLOCKS = Set.of(Material.BIG_DRIPLEAF, Material.BIG_DRIPLEAF_STEM);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(BIG_DRIPLEAF_BLOCKS::contains);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        if (BIG_DRIPLEAF_BLOCKS.contains(block.getType())) {
            Block above;
            HashSet<Block> blocks = new HashSet<Block>();
            Block below = block.getRelative(BlockFace.DOWN);
            if (BIG_DRIPLEAF_BLOCKS.contains(below.getType())) {
                Block next = block.getRelative(BlockFace.DOWN);
                while (BIG_DRIPLEAF_BLOCKS.contains(next.getType())) {
                    blocks.add(next);
                    next = next.getRelative(BlockFace.DOWN);
                }
            }
            if (BIG_DRIPLEAF_BLOCKS.contains((above = block.getRelative(BlockFace.UP)).getType())) {
                Block next = block.getRelative(BlockFace.UP);
                while (BIG_DRIPLEAF_BLOCKS.contains(next.getType())) {
                    blocks.add(next);
                    next = next.getRelative(BlockFace.UP);
                }
            }
            return Match.ofBlocks(blocks);
        }
        Block above = block.getRelative(BlockFace.UP);
        if (BIG_DRIPLEAF_BLOCKS.contains(above.getType())) {
            HashSet<Block> blocks = new HashSet<Block>();
            Block next = block.getRelative(BlockFace.UP);
            while (BIG_DRIPLEAF_BLOCKS.contains(next.getType())) {
                blocks.add(next);
                next = next.getRelative(BlockFace.UP);
            }
            return Match.ofBlocks(blocks);
        }
        return null;
    }
}

