/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bell;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class BellMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARTESIAN_FACES = EnumSet.of(BlockFace.NORTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN});
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(material -> material.createBlockData() instanceof Bell);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        for (BlockFace blockFace : CARTESIAN_FACES) {
            Block adjacent = block.getRelative(blockFace);
            BlockData blockData = adjacent.getBlockData();
            if (!(blockData instanceof Bell)) continue;
            Bell bell = (Bell)blockData;
            if (Bell.Attachment.CEILING.equals((Object)bell.getAttachment()) && BlockFace.DOWN.equals((Object)blockFace)) {
                return Match.ofBlocks(Collections.singleton(adjacent));
            }
            if (Bell.Attachment.FLOOR.equals((Object)bell.getAttachment()) && BlockFace.UP.equals((Object)blockFace)) {
                return Match.ofBlocks(Collections.singleton(adjacent));
            }
            if (Bell.Attachment.SINGLE_WALL.equals((Object)bell.getAttachment()) && blockFace.getOppositeFace().equals((Object)bell.getFacing())) {
                return Match.ofBlocks(Collections.singleton(adjacent));
            }
            if (!Bell.Attachment.DOUBLE_WALL.equals((Object)bell.getAttachment())) continue;
            return Match.ofBlocks(List.of(block.getRelative(bell.getFacing()), block.getRelative(bell.getFacing().getOppositeFace())));
        }
        return null;
    }
}

