/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class BedMatcher
implements BlockMatcher {
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(arg_0 -> ((Tag)Tag.BEDS).isTagged(arg_0));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled && Tag.BEDS.isTagged((Keyed)block.getType());
    }

    @Override
    public Match findMatch(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Bed) {
            Bed bed = (Bed)blockData;
            if (Bed.Part.FOOT.equals((Object)bed.getPart())) {
                Block head = block.getRelative(bed.getFacing());
                if (Tag.BEDS.isTagged((Keyed)head.getType())) {
                    return Match.ofBlocks(Collections.singleton(head));
                }
            } else {
                Block foot = block.getRelative(bed.getFacing().getOppositeFace());
                if (Tag.BEDS.isTagged((Keyed)foot.getType())) {
                    return Match.ofBlocks(Collections.singleton(foot));
                }
            }
        }
        return null;
    }
}

