/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.matcher.block;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.BlockMatcher;

public class BannerMatcher
implements BlockMatcher {
    private static final EnumSet<BlockFace> CARDINAL_FACES = EnumSet.of(BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);
    private boolean enabled;

    @Override
    public void initialize(Set<Material> protectableBlocks, Set<EntityType> protectableEntities) {
        this.enabled = protectableBlocks.stream().anyMatch(arg_0 -> ((Tag)Tag.BANNERS).isTagged(arg_0));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public boolean canMatch(Block block) {
        return this.enabled;
    }

    @Override
    public Match findMatch(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        if (Tag.BANNERS.isTagged((Keyed)above.getType()) && !(above.getBlockData() instanceof Directional)) {
            return Match.ofBlocks(Collections.singleton(above));
        }
        for (BlockFace blockFace : CARDINAL_FACES) {
            Directional directional;
            BlockData blockData;
            Block wall = block.getRelative(blockFace);
            if (!Tag.BANNERS.isTagged((Keyed)wall.getType()) || !((blockData = wall.getBlockData()) instanceof Directional) || !blockFace.equals((Object)(directional = (Directional)blockData).getFacing())) continue;
            return Match.ofBlocks(Collections.singleton(wall));
        }
        return null;
    }
}

