/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.listeners.adapter;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.SideChaining;
import org.bukkit.block.data.type.Shelf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectedShelves {
    private static final boolean CAN_USE = ConnectedShelves.classExists();

    private static boolean classExists() {
        try {
            Class.forName("org.bukkit.block.data.type.Shelf");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean canUse() {
        return CAN_USE;
    }

    public static List<@NotNull Block> connectedShelves(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Shelf)) {
            return List.of();
        }
        Shelf shelf = (Shelf)blockData;
        ArrayList<@NotNull Block> list = new ArrayList<Block>(3);
        list.add(block);
        switch (shelf.getSideChain()) {
            case UNCONNECTED: {
                break;
            }
            case RIGHT: {
                Block center = ConnectedShelves.adjacent(block, Direction.LEFT);
                if (center == null) break;
                list.add(center);
                Block left = ConnectedShelves.adjacent(center, Direction.LEFT);
                if (left == null) break;
                list.add(left);
                break;
            }
            case CENTER: {
                Block right;
                Block left = ConnectedShelves.adjacent(block, Direction.LEFT);
                if (left != null) {
                    list.add(left);
                }
                if ((right = ConnectedShelves.adjacent(block, Direction.RIGHT)) == null) break;
                list.add(right);
                break;
            }
            case LEFT: {
                Block center = ConnectedShelves.adjacent(block, Direction.RIGHT);
                if (center == null) break;
                list.add(center);
                Block right = ConnectedShelves.adjacent(center, Direction.RIGHT);
                if (right == null) break;
                list.add(right);
            }
        }
        return list;
    }

    @Nullable
    private static Block adjacent(@Nullable Block block, Direction direction) {
        Shelf shelf;
        Block adjacent;
        BlockData blockData;
        BlockFace adjacentFace;
        BlockData blockData2;
        if (block == null || !((blockData2 = block.getBlockData()) instanceof Directional)) {
            return null;
        }
        Directional directional = (Directional)blockData2;
        switch (directional.getFacing()) {
            case NORTH: {
                BlockFace blockFace;
                if (direction == Direction.LEFT) {
                    blockFace = BlockFace.EAST;
                    break;
                }
                blockFace = BlockFace.WEST;
                break;
            }
            case SOUTH: {
                BlockFace blockFace;
                if (direction == Direction.LEFT) {
                    blockFace = BlockFace.WEST;
                    break;
                }
                blockFace = BlockFace.EAST;
                break;
            }
            case EAST: {
                BlockFace blockFace;
                if (direction == Direction.LEFT) {
                    blockFace = BlockFace.SOUTH;
                    break;
                }
                blockFace = BlockFace.NORTH;
                break;
            }
            case WEST: {
                BlockFace blockFace;
                if (direction == Direction.LEFT) {
                    blockFace = BlockFace.NORTH;
                    break;
                }
                blockFace = BlockFace.SOUTH;
                break;
            }
            default: {
                BlockFace blockFace = adjacentFace = null;
            }
        }
        if (adjacentFace != null && (blockData = (adjacent = block.getRelative(adjacentFace)).getBlockData()) instanceof Shelf && (shelf = (Shelf)blockData).getSideChain() != SideChaining.ChainPart.UNCONNECTED) {
            return adjacent;
        }
        return null;
    }

    private static enum Direction {
        LEFT,
        RIGHT;

    }
}

