/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.listeners;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.Mode;

public final class PlayerListener
implements Listener {
    private final BoltPlugin plugin;

    public PlayerListener(BoltPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        Set<Mode> defaultModes = this.plugin.defaultModes();
        this.plugin.getProfileCache().add(uuid, player.getName());
        CompletableFuture.runAsync(() -> {
            YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)this.plugin.getDataPath().resolve("players/%s.yml".formatted(uuid)).toFile());
            BoltPlayer boltPlayer = this.plugin.getBolt().getBoltPlayer(uuid);
            boolean hasPersist = playerConfig.getBoolean(Mode.PERSIST.name().toLowerCase(), defaultModes.contains((Object)Mode.PERSIST));
            if (!boltPlayer.hasMode(Mode.PERSIST) && hasPersist) {
                boltPlayer.toggleMode(Mode.PERSIST);
            }
            boolean hasNoLock = playerConfig.getBoolean(Mode.NOLOCK.name().toLowerCase(), defaultModes.contains((Object)Mode.NOLOCK));
            if (!boltPlayer.hasMode(Mode.NOLOCK) && hasNoLock) {
                boltPlayer.toggleMode(Mode.NOLOCK);
            }
            boolean hasNoSpam = playerConfig.getBoolean(Mode.NOSPAM.name().toLowerCase(), defaultModes.contains((Object)Mode.NOSPAM));
            if (!boltPlayer.hasMode(Mode.NOSPAM) && hasNoSpam) {
                boltPlayer.toggleMode(Mode.NOSPAM);
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.plugin.getBolt().removeBoltPlayer(e.getPlayer().getUniqueId());
    }
}

