/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.listeners;

import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceResolver;
import org.popcraft.bolt.source.SourceTypeResolver;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.EnumUtil;

public final class InventoryListener
implements Listener {
    private static final SourceResolver BLOCK_SOURCE_RESOLVER = new SourceTypeResolver(Source.of("block"));
    private static final SourceResolver REDSTONE_SOURCE_RESOLVER = new SourceTypeResolver(Source.of("redstone"));
    private static final Tag<Material> COPPER_CHESTS = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"copper_chests"), Material.class);
    private static final Map<InventoryType, Set<Material>> INVENTORY_TYPE_BLOCKS = Map.ofEntries(Map.entry(InventoryType.ANVIL, Set.of(Material.ANVIL, Material.CHIPPED_ANVIL, Material.DAMAGED_ANVIL)), Map.entry(InventoryType.BARREL, Set.of(Material.BARREL)), Map.entry(InventoryType.BLAST_FURNACE, Set.of(Material.BLAST_FURNACE)), Map.entry(InventoryType.CHEST, new HashSet<Material>(Set.of(Material.CHEST, Material.TRAPPED_CHEST))), Map.entry(InventoryType.CRAFTER, Set.of(Material.CRAFTER)), Map.entry(InventoryType.DISPENSER, Set.of(Material.DISPENSER)), Map.entry(InventoryType.DROPPER, Set.of(Material.DROPPER)), Map.entry(InventoryType.FURNACE, Set.of(Material.FURNACE)), Map.entry(InventoryType.HOPPER, Set.of(Material.HOPPER)), Map.entry(InventoryType.SHULKER_BOX, Set.of(Material.SHULKER_BOX)), Map.entry(InventoryType.SMOKER, Set.of(Material.SMOKER)));
    private static final InventoryAction PICKUP_FROM_BUNDLE;
    private static final InventoryAction PICKUP_ALL_INTO_BUNDLE;
    private static final InventoryAction PICKUP_SOME_INTO_BUNDLE;
    private static final InventoryAction PLACE_FROM_BUNDLE;
    private static final InventoryAction PLACE_ALL_INTO_BUNDLE;
    private static final InventoryAction PLACE_SOME_INTO_BUNDLE;
    private final BoltPlugin plugin;

    public InventoryListener(BoltPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        BoltPlayer boltPlayer = this.plugin.player(player);
        if (boltPlayer.triggeredAction()) {
            e.setCancelled(true);
            return;
        }
        Protection protection = this.getInventoryProtection(e.getInventory());
        if (protection != null && !this.plugin.canAccess(protection, player, "open")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        boolean shouldCancel;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory clickedInventory = e.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        InventoryAction action = e.getAction();
        if (InventoryAction.CLONE_STACK.equals((Object)action) || InventoryAction.DROP_ALL_CURSOR.equals((Object)action) || InventoryAction.DROP_ONE_CURSOR.equals((Object)action) || InventoryAction.NOTHING.equals((Object)action)) {
            return;
        }
        InventoryType clickedInventoryType = e.getClickedInventory().getType();
        if (InventoryType.PLAYER.equals((Object)clickedInventoryType) && !InventoryAction.COLLECT_TO_CURSOR.equals((Object)action) && !InventoryAction.MOVE_TO_OTHER_INVENTORY.equals((Object)action)) {
            return;
        }
        Protection protection = this.getInventoryProtection(e.getInventory());
        if (protection == null) {
            return;
        }
        switch (action) {
            case PLACE_ALL: 
            case PLACE_ONE: 
            case PLACE_SOME: {
                boolean bl;
                if (!this.plugin.canAccess(protection, player, "deposit")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case COLLECT_TO_CURSOR: 
            case DROP_ALL_SLOT: 
            case DROP_ONE_SLOT: 
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_ONE: 
            case PICKUP_SOME: {
                boolean bl;
                if (!this.plugin.canAccess(protection, player, "withdraw")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case HOTBAR_MOVE_AND_READD: 
            case SWAP_WITH_CURSOR: 
            case UNKNOWN: {
                boolean bl;
                if (!this.plugin.canAccess(protection, player, "deposit", "withdraw")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                boolean bl;
                String[] stringArray = new String[1];
                String string = stringArray[0] = InventoryType.PLAYER.equals((Object)clickedInventoryType) ? "deposit" : "withdraw";
                if (!this.plugin.canAccess(protection, player, stringArray)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case HOTBAR_SWAP: {
                boolean bl;
                ItemStack clickedItem = e.getCurrentItem();
                if (clickedItem == null) {
                    if (!this.plugin.canAccess(protection, player, "deposit", "withdraw")) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (clickedItem.getType().isAir()) {
                    if (!this.plugin.canAccess(protection, player, "deposit")) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (!this.plugin.canAccess(protection, player, "withdraw")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl;
                if (action == PICKUP_FROM_BUNDLE || action == PICKUP_ALL_INTO_BUNDLE || action == PICKUP_SOME_INTO_BUNDLE) {
                    if (!this.plugin.canAccess(protection, player, "withdraw")) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (action == PLACE_FROM_BUNDLE || action == PLACE_ALL_INTO_BUNDLE || action == PLACE_SOME_INTO_BUNDLE) {
                    if (!this.plugin.canAccess(protection, player, "deposit")) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = shouldCancel = true;
            }
        }
        if (shouldCancel) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        Object object = e.getWhoClicked();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        object = e.getRawSlots().iterator();
        while (object.hasNext()) {
            Protection protection;
            int rawSlot = (Integer)object.next();
            Inventory slotInventory = e.getView().getInventory(rawSlot);
            if (slotInventory == null || InventoryType.PLAYER.equals((Object)slotInventory.getType()) || (protection = this.getInventoryProtection(slotInventory)) == null || this.plugin.canAccess(protection, player, "deposit")) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent e) {
        Protection sourceProtection = this.getInventoryProtection(e.getSource());
        Protection destinationProtection = this.getInventoryProtection(e.getDestination());
        if (sourceProtection == null && destinationProtection == null) {
            return;
        }
        if (sourceProtection != null && InventoryType.DROPPER.equals((Object)e.getSource().getType()) && !this.plugin.canAccess(sourceProtection, REDSTONE_SOURCE_RESOLVER, "redstone")) {
            e.setCancelled(true);
            return;
        }
        if (sourceProtection != null && destinationProtection != null) {
            if (!this.plugin.canAccess(destinationProtection, sourceProtection.getOwner(), "deposit") || !this.plugin.canAccess(sourceProtection, destinationProtection.getOwner(), "withdraw")) {
                e.setCancelled(true);
            }
        } else if (sourceProtection != null && !this.plugin.canAccess(sourceProtection, BLOCK_SOURCE_RESOLVER, "withdraw")) {
            e.setCancelled(true);
        } else if (destinationProtection != null && !this.plugin.canAccess(destinationProtection, BLOCK_SOURCE_RESOLVER, "deposit")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onTradeSelect(TradeSelectEvent e) {
        Player player;
        HumanEntity humanEntity;
        block5: {
            block4: {
                humanEntity = e.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block4;
                player = (Player)humanEntity;
                humanEntity = e.getInventory().getHolder();
                if (humanEntity instanceof Entity) break block5;
            }
            return;
        }
        Entity entity = (Entity)humanEntity;
        if (!this.plugin.canAccess(entity, player, "deposit")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onAnvilDamaged(AnvilDamagedEvent e) {
        if (!e.isBreaking()) {
            return;
        }
        Protection anvilProtection = this.getInventoryProtection((Inventory)e.getInventory());
        if (anvilProtection == null) {
            return;
        }
        this.plugin.removeProtection(anvilProtection);
    }

    private Protection getInventoryProtection(Inventory inventory) {
        Block block;
        Location inventoryLocation;
        InventoryType inventoryType = inventory.getType();
        Set<Material> blockTypes = INVENTORY_TYPE_BLOCKS.get(inventoryType);
        if (blockTypes != null && (inventoryLocation = inventory.getLocation()) != null && blockTypes.contains((block = inventoryLocation.getBlock()).getType())) {
            return this.plugin.findProtection(block);
        }
        return this.getHolderProtection(inventory.getHolder());
    }

    private Protection getHolderProtection(InventoryHolder inventoryHolder) {
        if (inventoryHolder instanceof Entity) {
            Entity entity = (Entity)inventoryHolder;
            return this.plugin.findProtection(entity);
        }
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)inventoryHolder;
            return this.plugin.findProtection(blockInventoryHolder.getBlock());
        }
        if (inventoryHolder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
            return this.plugin.findProtection(doubleChest.getLocation().getBlock());
        }
        return null;
    }

    static {
        if (COPPER_CHESTS != null) {
            INVENTORY_TYPE_BLOCKS.get(InventoryType.CHEST).addAll(COPPER_CHESTS.getValues());
        }
        PICKUP_FROM_BUNDLE = EnumUtil.valueOf(InventoryAction.class, "PICKUP_FROM_BUNDLE").orElse(null);
        PICKUP_ALL_INTO_BUNDLE = EnumUtil.valueOf(InventoryAction.class, "PICKUP_ALL_INTO_BUNDLE").orElse(null);
        PICKUP_SOME_INTO_BUNDLE = EnumUtil.valueOf(InventoryAction.class, "PICKUP_SOME_INTO_BUNDLE").orElse(null);
        PLACE_FROM_BUNDLE = EnumUtil.valueOf(InventoryAction.class, "PLACE_FROM_BUNDLE").orElse(null);
        PLACE_ALL_INTO_BUNDLE = EnumUtil.valueOf(InventoryAction.class, "PLACE_ALL_INTO_BUNDLE").orElse(null);
        PLACE_SOME_INTO_BUNDLE = EnumUtil.valueOf(InventoryAction.class, "PLACE_SOME_INTO_BUNDLE").orElse(null);
    }
}

