/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.listeners;

import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.event.Cancellable;
import org.popcraft.bolt.event.LockBlockEvent;
import org.popcraft.bolt.event.LockEntityEvent;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.ProtectableConfig;
import org.popcraft.bolt.util.Protections;
import org.popcraft.bolt.util.SchedulerUtil;
import org.popcraft.bolt.util.Time;

abstract class InteractionListener {
    protected final BoltPlugin plugin;

    protected InteractionListener(BoltPlugin plugin) {
        this.plugin = plugin;
    }

    protected boolean triggerAction(Player player, Protection protection, Block block) {
        boolean protectable = this.plugin.isProtectable(block);
        ProtectableConfig config = this.plugin.getProtectableConfig(block);
        Component displayName = Protections.displayType(block, (CommandSender)player);
        String lockPermission = "bolt.protection.lock.%s".formatted(block.getType().name().toLowerCase());
        return this.triggerAction(player, protection, block, protectable, config, displayName, lockPermission);
    }

    protected boolean triggerAction(Player player, Protection protection, Entity entity) {
        boolean protectable = this.plugin.isProtectable(entity);
        ProtectableConfig config = this.plugin.getProtectableConfig(entity);
        Component displayName = Protections.displayType(entity, (CommandSender)player);
        String lockPermission = "bolt.protection.lock.%s".formatted(entity.getType().name().toLowerCase());
        return this.triggerAction(player, protection, entity, protectable, config, displayName, lockPermission);
    }

    private boolean triggerAction(Player player, Protection protection, Object object, boolean protectable, ProtectableConfig config, Component displayName, String lockPermission) {
        BoltPlayer boltPlayer = this.plugin.player(player);
        Action action = boltPlayer.getAction();
        if (action == null) {
            return false;
        }
        if (!player.hasPermission(action.getPermission())) {
            BoltComponents.sendMessage((CommandSender)player, "command_no_permission", new TagResolver[0]);
            return false;
        }
        Action.Type actionType = action.getType();
        switch (actionType) {
            case LOCK: {
                boolean requiresLockPermission;
                Cancellable event;
                if (object instanceof Block) {
                    Block block = (Block)object;
                    event = new LockBlockEvent(player, block, false);
                } else if (object instanceof Entity) {
                    Entity entity = (Entity)object;
                    event = new LockEntityEvent(player, entity, false);
                } else {
                    throw new IllegalStateException("Protection is not a block or entity");
                }
                this.plugin.getEventBus().post(event);
                if (event.isCancelled()) {
                    BoltComponents.sendMessage((CommandSender)player, "click_locked_cancelled", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)displayName)});
                    break;
                }
                String protectionType = Optional.ofNullable(action.getData()).flatMap(type -> this.plugin.getBolt().getAccessRegistry().getProtectionByType((String)type)).map(Access::type).orElse(this.plugin.getDefaultProtectionType());
                boolean bl = requiresLockPermission = config != null && config.lockPermission();
                if (protection != null) {
                    if (!protection.getType().equals(protectionType) && this.plugin.canAccess(protection, player, "edit")) {
                        protection.setType(protectionType);
                        this.plugin.saveProtection(protection);
                        BoltComponents.sendMessage((CommandSender)player, "click_locked_changed", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player))});
                        break;
                    }
                    BoltComponents.sendMessage((CommandSender)player, "click_locked_already", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                    break;
                }
                if ((protectable || action.isAdmin()) && (!requiresLockPermission || player.hasPermission(lockPermission))) {
                    Protection newProtection;
                    UUID protectionUUID;
                    UUID uUID = protectionUUID = boltPlayer.isLockNil() ? Profiles.NIL_UUID : player.getUniqueId();
                    if (object instanceof Block) {
                        Block block = (Block)object;
                        newProtection = this.plugin.createProtection(block, protectionUUID, protectionType);
                    } else if (object instanceof Entity) {
                        Entity entity = (Entity)object;
                        newProtection = this.plugin.createProtection(entity, protectionUUID, protectionType);
                    } else {
                        throw new IllegalStateException("Protection is not a block or entity");
                    }
                    this.plugin.saveProtection(newProtection);
                    boltPlayer.setLockNil(false);
                    BoltComponents.sendMessage((CommandSender)player, "click_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(newProtection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)displayName)});
                    break;
                }
                BoltComponents.sendMessage((CommandSender)player, "click_not_lockable", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)displayName)});
                break;
            }
            case UNLOCK: {
                if (protection != null) {
                    if (this.plugin.canAccess(protection, player, "destroy")) {
                        this.plugin.removeProtection(protection);
                        BoltComponents.sendMessage((CommandSender)player, "click_unlocked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                        break;
                    }
                    BoltComponents.sendMessage((CommandSender)player, "click_unlocked_no_permission", this.plugin.isUseActionBar(), new TagResolver[0]);
                    break;
                }
                BoltComponents.sendMessage((CommandSender)player, "click_not_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)displayName)});
                break;
            }
            case INFO: {
                if (protection != null) {
                    boolean showFull = protection.getOwner().equals(player.getUniqueId()) || player.hasPermission("bolt.command.info.full");
                    boolean showAccessList = !protection.getAccess().isEmpty();
                    Profiles.findOrLookupProfileByUniqueId(protection.getOwner()).thenAccept(profile -> SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, showFull ? (showAccessList ? "info_full_access" : "info_full_no_access") : "info", new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player)), Placeholder.component((String)"player", (ComponentLike)((ComponentLike)Optional.ofNullable(profile.name()).map(Component::text).orElse(BoltComponents.resolveTranslation("unknown", (CommandSender)player, new TagResolver[0])))), Placeholder.component((String)"access_list_size", (ComponentLike)Component.text((int)protection.getAccess().size())), Placeholder.component((String)"access_list", (ComponentLike)Protections.accessList(protection.getAccess(), (CommandSender)player)), Placeholder.component((String)"created_time", (ComponentLike)Time.relativeTimestamp(protection.getCreated(), (CommandSender)player)), Placeholder.component((String)"accessed_time", (ComponentLike)Time.relativeTimestamp(protection.getAccessed(), (CommandSender)player))})));
                    break;
                }
                BoltComponents.sendMessage((CommandSender)player, "click_not_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)displayName)});
                break;
            }
            case EDIT: {
                if (protection != null) {
                    if (this.plugin.canAccess(protection, player, "edit")) {
                        boltPlayer.consumeModifications().forEach((source, type) -> {
                            if (Boolean.parseBoolean(action.getData())) {
                                protection.getAccess().put(source.toString(), (String)type);
                            } else {
                                protection.getAccess().remove(source.toString());
                            }
                        });
                        this.plugin.saveProtection(protection);
                        BoltComponents.sendMessage((CommandSender)player, "click_edited", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                        break;
                    }
                    BoltComponents.sendMessage((CommandSender)player, "click_edited_no_permission", this.plugin.isUseActionBar(), new TagResolver[0]);
                    break;
                }
                BoltComponents.sendMessage((CommandSender)player, "click_not_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)displayName)});
                break;
            }
            case DEBUG: {
                BoltComponents.sendMessage((CommandSender)player, Optional.ofNullable(protection).map(Protection::toString).toString(), new TagResolver[0]);
                break;
            }
            case TRANSFER: {
                if (protection != null) {
                    if (player.getUniqueId().equals(protection.getOwner()) || action.isAdmin()) {
                        UUID uuid = UUID.fromString(action.getData());
                        protection.setOwner(uuid);
                        this.plugin.saveProtection(protection);
                        Profiles.findOrLookupProfileByUniqueId(uuid).thenAccept(profile -> SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "click_transfer_confirm", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player)), Placeholder.component((String)"player", (ComponentLike)((ComponentLike)Optional.ofNullable(profile.name()).map(Component::text).orElse(BoltComponents.resolveTranslation("unknown", (CommandSender)player, new TagResolver[0]))))})));
                        break;
                    }
                    BoltComponents.sendMessage((CommandSender)player, "click_edited_no_owner", this.plugin.isUseActionBar(), new TagResolver[0]);
                    break;
                }
                BoltComponents.sendMessage((CommandSender)player, "click_not_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)displayName)});
            }
        }
        boltPlayer.clearAction();
        return true;
    }
}

