/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.SheepDyeWoolEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.event.LockEntityEvent;
import org.popcraft.bolt.listeners.InteractionListener;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceResolver;
import org.popcraft.bolt.source.SourceTypeResolver;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.BukkitPlayerResolver;
import org.popcraft.bolt.util.EnumUtil;
import org.popcraft.bolt.util.Mode;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.ProtectableConfig;
import org.popcraft.bolt.util.Protections;
import org.popcraft.bolt.util.SchedulerUtil;

public final class EntityListener
extends InteractionListener
implements Listener {
    private static final SourceResolver ENTITY_SOURCE_RESOLVER = new SourceTypeResolver(Source.of("entity"));
    private static final EntityType COPPER_GOLEM = EnumUtil.valueOf(EntityType.class, "COPPER_GOLEM").orElse(null);
    private static final Tag<Material> COPPER_GOLEM_STATUES = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"copper_golem_statues"), Material.class);
    private static final CreatureSpawnEvent.SpawnReason REANIMATE = EnumUtil.valueOf(CreatureSpawnEvent.SpawnReason.class, "REANIMATE").orElse(null);
    private final Map<NamespacedKey, UUID> spawnEggPlayers = new HashMap<NamespacedKey, UUID>();
    private final Map<BlockLocation, BlockProtection> reanimatedCopperGolems = new HashMap<BlockLocation, BlockProtection>();

    public EntityListener(BoltPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!Action.RIGHT_CLICK_BLOCK.equals((Object)e.getAction())) {
            return;
        }
        NamespacedKey spawnEggKey = e.getMaterial().getKey();
        if (!spawnEggKey.getKey().endsWith("_spawn_egg")) {
            return;
        }
        NamespacedKey entityKey = NamespacedKey.minecraft((String)spawnEggKey.getKey().replace("_spawn_egg", ""));
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        this.spawnEggPlayers.put(entityKey, uuid);
        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> this.spawnEggPlayers.remove(entityKey));
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        LivingEntity entity = e.getEntity();
        if (CreatureSpawnEvent.SpawnReason.SPAWNER_EGG.equals((Object)e.getSpawnReason())) {
            UUID uuid = this.spawnEggPlayers.remove(entity.getType().getKey());
            if (uuid == null) {
                return;
            }
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player != null) {
                this.handleEntityPlacementByPlayer((Entity)entity, player);
            }
        } else if (entity.getType() == COPPER_GOLEM && e.getSpawnReason().equals((Object)REANIMATE)) {
            Location location = e.getLocation();
            BlockLocation blockLocation = new BlockLocation(entity.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
            BlockProtection blockProtection = this.reanimatedCopperGolems.remove(blockLocation);
            if (blockProtection == null) {
                return;
            }
            EntityProtection newProtection = this.plugin.createProtection((Entity)entity, blockProtection.getOwner(), blockProtection.getType());
            newProtection.setAccess(blockProtection.getAccess());
            this.plugin.saveProtection(newProtection);
        }
    }

    @EventHandler
    public void onEntityPlace(EntityPlaceEvent e) {
        Player player = e.getPlayer();
        if (player != null) {
            this.handleEntityPlacementByPlayer(e.getEntity(), player);
        }
    }

    @EventHandler
    public void onHangingPlace(HangingPlaceEvent e) {
        Player player = e.getPlayer();
        if (player != null) {
            this.handleEntityPlacementByPlayer((Entity)e.getEntity(), player);
        }
    }

    private void handleEntityPlacementByPlayer(Entity entity, Player player) {
        if (this.plugin.player(player.getUniqueId()).hasMode(Mode.NOLOCK)) {
            return;
        }
        if (!this.plugin.isProtectable(entity)) {
            return;
        }
        ProtectableConfig protectableConfig = this.plugin.getProtectableConfig(entity);
        if (protectableConfig == null) {
            return;
        }
        if (protectableConfig.autoProtectPermission() && !player.hasPermission("bolt.protection.autoprotect.%s".formatted(entity.getType().name().toLowerCase()))) {
            return;
        }
        Access access = protectableConfig.defaultAccess();
        if (access == null) {
            return;
        }
        if (access.restricted() && !player.hasPermission("bolt.type.protection.%s".formatted(access.type()))) {
            return;
        }
        LockEntityEvent event = new LockEntityEvent(player, entity, true);
        this.plugin.getEventBus().post(event);
        if (event.isCancelled()) {
            return;
        }
        EntityProtection newProtection = this.plugin.createProtection(entity, player.getUniqueId(), access.type());
        this.plugin.saveProtection(newProtection);
        if (!this.plugin.player(player.getUniqueId()).hasMode(Mode.NOSPAM)) {
            BoltComponents.sendMessage((CommandSender)player, "click_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(newProtection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(entity, (CommandSender)player))});
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent e) {
        Player player;
        EntityDamageByEntityEvent entityDamageByEntityEvent;
        LivingEntity entity = e.getEntity();
        Protection protection = this.plugin.findProtection((Entity)entity);
        if (protection == null) {
            return;
        }
        this.plugin.removeProtection(protection);
        EntityDamageEvent entityDamageEvent = e.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent && (entityDamageEvent = this.getDamagerSource((entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent).getDamager())) instanceof Player && this.plugin.canAccess(protection, player = (Player)entityDamageEvent, "destroy")) {
            BoltComponents.sendMessage((CommandSender)player, "click_unlocked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent e) {
        if (this.handlePlayerEntityInteraction(e.getPlayer(), e.getRightClicked(), "interact", EquipmentSlot.HAND.equals((Object)e.getHand()))) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent e) {
        Player player;
        Entity damager = this.getDamagerSource(e.getDamager());
        Entity entity = e.getEntity();
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (damager instanceof Player) {
                boolean itemInFrame;
                Player player2 = (Player)damager;
                boolean bl = itemInFrame = !itemFrame.getItem().getType().isAir();
                if (itemInFrame && !this.plugin.canAccess(entity, player2, "withdraw")) {
                    e.setCancelled(true);
                }
                return;
            }
        }
        if (damager instanceof Player && this.handlePlayerEntityInteraction(player = (Player)damager, entity, "destroy", true) || !(damager instanceof Player) && this.plugin.isProtected(entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent e) {
        Player player;
        Entity attacker = this.getDamagerSource(e.getAttacker());
        Vehicle vehicle = e.getVehicle();
        if (attacker instanceof Player && this.handlePlayerEntityInteraction(player = (Player)attacker, (Entity)vehicle, "interact", true)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHangingBreakByEntity(HangingBreakByEntityEvent e) {
        Hanging entity = e.getEntity();
        Entity entity2 = this.getDamagerSource(e.getRemover());
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            if (this.handlePlayerEntityInteraction(player, (Entity)entity, "destroy", true)) {
                e.setCancelled(true);
            } else {
                Protection protection = this.plugin.findProtection((Entity)entity);
                if (protection == null) {
                    return;
                }
                this.plugin.removeProtection(protection);
                if (this.plugin.canAccess(protection, player, "destroy")) {
                    BoltComponents.sendMessage((CommandSender)player, "click_unlocked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                }
            }
        } else if (this.plugin.isProtected((Entity)entity)) {
            e.setCancelled(true);
        }
    }

    private boolean handlePlayerEntityInteraction(Player player, Entity entity, String permission, boolean shouldSendMessage) {
        if (entity == null) {
            return false;
        }
        BoltPlayer boltPlayer = this.plugin.player(player);
        if (boltPlayer.hasInteracted()) {
            return true;
        }
        boolean shouldCancel = false;
        Protection protection = this.plugin.findProtection(entity);
        if (this.triggerAction(player, protection, entity)) {
            boltPlayer.setInteracted(true);
            SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, boltPlayer::clearInteraction);
            shouldCancel = true;
        } else if (protection != null) {
            boolean canInteract;
            boolean hasNotifyPermission = player.hasPermission("bolt.protection.notify");
            boolean canAccess = this.plugin.canAccess(protection, player, permission);
            boolean bl = canInteract = canAccess && "interact".equals(permission);
            if (canInteract && protection instanceof EntityProtection) {
                EntityProtection entityProtection = (EntityProtection)protection;
                protection.setAccessed(System.currentTimeMillis());
                this.plugin.saveProtection(entityProtection);
            }
            if (!canAccess) {
                shouldCancel = true;
                if (shouldSendMessage && !hasNotifyPermission) {
                    BoltComponents.sendMessage((CommandSender)player, "locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                }
            }
            if (shouldSendMessage && hasNotifyPermission) {
                Profiles.findOrLookupProfileByUniqueId(protection.getOwner()).thenAccept(profile -> {
                    String owner;
                    boolean noSpam = this.plugin.player(player.getUniqueId()).hasMode(Mode.NOSPAM);
                    if (noSpam) {
                        return;
                    }
                    boolean isYou = player.getUniqueId().equals(protection.getOwner());
                    String string = owner = isYou ? BoltComponents.translateRaw("you", (CommandSender)player) : profile.name();
                    if (owner == null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> {
                            if (!this.plugin.isProtected(entity)) {
                                return;
                            }
                            BoltComponents.sendMessage((CommandSender)player, "protection_notify_generic", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                        });
                    } else if (!isYou || player.hasPermission("bolt.protection.notify.self")) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> {
                            if (!this.plugin.isProtected(entity)) {
                                return;
                            }
                            BoltComponents.sendMessage((CommandSender)player, "protection_notify", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player)), Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))});
                        });
                    }
                });
            }
            boltPlayer.setInteracted(shouldCancel);
            SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, boltPlayer::clearInteraction);
        }
        return shouldCancel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent e) {
        Vehicle vehicle = e.getVehicle();
        Protection protection = this.plugin.findProtection((Entity)vehicle);
        if (protection == null) {
            return;
        }
        Entity entity = this.getDamagerSource(e.getAttacker());
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.plugin.canAccess(protection, player, "destroy")) {
                this.plugin.removeProtection(protection);
                BoltComponents.sendMessage((CommandSender)player, "click_unlocked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                return;
            }
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent e) {
        Protection protection = this.plugin.findProtection(e.getEntered());
        if (protection == null) {
            return;
        }
        if (!this.plugin.canAccess(protection, e.getEntered().getUniqueId(), "mount")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        if (this.plugin.player(player).triggeredAction()) {
            e.setCancelled(true);
            return;
        }
        Entity entity = e.getRightClicked();
        if (!this.plugin.canAccess(entity, player, "interact")) {
            e.setCancelled(true);
            return;
        }
        Entity entity2 = e.getRightClicked();
        if (entity2 instanceof ItemFrame) {
            boolean hasItemInHand;
            ItemFrame itemFrame = (ItemFrame)entity2;
            boolean noItemInFrame = itemFrame.getItem().getType().isAir();
            boolean bl = hasItemInHand = !e.getPlayer().getInventory().getItem(e.getHand()).isEmpty();
            if (noItemInFrame && hasItemInHand && !this.plugin.canAccess(entity, player, "deposit")) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent e) {
        Player player = e.getPlayer();
        ArmorStand entity = e.getRightClicked();
        if (!this.plugin.canAccess((Entity)entity, player, "interact")) {
            e.setCancelled(true);
            return;
        }
        boolean hasPlayerItem = !e.getPlayerItem().getType().isAir();
        boolean hasArmorStandItem = !e.getArmorStandItem().getType().isAir();
        ArrayList<String> permissionsToCheck = new ArrayList<String>();
        if (hasPlayerItem) {
            permissionsToCheck.add("deposit");
        }
        if (hasArmorStandItem) {
            permissionsToCheck.add("withdraw");
        }
        if (!permissionsToCheck.isEmpty() && !this.plugin.canAccess((Entity)entity, player, permissionsToCheck.toArray(new String[0]))) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHangingBreak(HangingBreakEvent e) {
        if (HangingBreakEvent.RemoveCause.ENTITY.equals((Object)e.getCause())) {
            return;
        }
        if (this.plugin.isProtected((Entity)e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (e instanceof EntityDamageByEntityEvent) {
            return;
        }
        if (EntityDamageEvent.DamageCause.ENTITY_ATTACK.equals((Object)e.getCause()) || EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK.equals((Object)e.getCause()) || EntityDamageEvent.DamageCause.PROJECTILE.equals((Object)e.getCause()) || EntityDamageEvent.DamageCause.ENTITY_EXPLOSION.equals((Object)e.getCause())) {
            return;
        }
        if (this.plugin.isProtected(e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityMount(EntityMountEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.plugin.player(player).triggeredAction() || !this.plugin.canAccess(e.getMount(), player, "mount")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSheepDyeWool(SheepDyeWoolEvent e) {
        Protection protection = this.plugin.findProtection((Entity)e.getEntity());
        if (protection == null) {
            return;
        }
        Player player = e.getPlayer();
        if (player == null || !this.plugin.canAccess(protection, player, "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerShearEntity(PlayerShearEntityEvent e) {
        if (!this.plugin.canAccess(e.getEntity(), e.getPlayer(), "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockShearEntity(BlockShearEntityEvent e) {
        if (this.plugin.isProtected(e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerLeashEntity(PlayerLeashEntityEvent e) {
        if (!this.plugin.canAccess(e.getEntity(), e.getPlayer(), "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerUnleashEntity(PlayerUnleashEntityEvent e) {
        if (!this.plugin.canAccess(e.getEntity(), e.getPlayer(), "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityUnleash(EntityUnleashEvent e) {
        LivingEntity entity;
        Entity entity2;
        if (EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH.equals((Object)e.getReason()) || !((entity2 = e.getEntity()) instanceof LivingEntity) || !(entity = (LivingEntity)entity2).isLeashed()) {
            return;
        }
        Protection protection = this.plugin.findProtection(entity.getLeashHolder());
        if (protection == null) {
            return;
        }
        if (EntityUnleashEvent.UnleashReason.DISTANCE.equals((Object)e.getReason())) {
            if (entity.getPassengers().stream().anyMatch(passenger -> this.plugin.canAccess(protection, passenger.getUniqueId(), "destroy"))) {
                this.plugin.removeProtection(protection);
            } else {
                entity.eject();
                e.setCancelled(true);
            }
        } else {
            this.plugin.removeProtection(protection);
        }
    }

    @EventHandler
    public void onEntityTransform(EntityTransformEvent e) {
        if (this.plugin.isProtected(e.getTransformedEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent e) {
        LivingEntity livingEntity;
        if (EntityTargetEvent.TargetReason.TEMPT.equals((Object)e.getReason()) && (livingEntity = e.getTarget()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!this.plugin.canAccess(e.getEntity(), player, "interact")) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityCombustByBlock(EntityCombustByBlockEvent e) {
        if (this.plugin.isProtected(e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityCombustByEntity(EntityCombustByEntityEvent e) {
        block5: {
            block4: {
                Protection protection = this.plugin.findProtection(e.getEntity());
                if (protection == null) {
                    return;
                }
                Entity entity = this.getDamagerSource(e.getCombuster());
                if (!(entity instanceof Player)) break block4;
                Player player = (Player)entity;
                if (this.plugin.canAccess(protection, player, "destroy")) break block5;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerBucketEntity(PlayerBucketEntityEvent e) {
        Protection protection = this.plugin.findProtection(e.getEntity());
        if (protection == null) {
            return;
        }
        if (!this.plugin.canAccess(protection, e.getPlayer(), "destroy")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent e) {
        block6: {
            block5: {
                Entity hitEntity = e.getHitEntity();
                if (hitEntity == null) {
                    return;
                }
                Protection protection = this.plugin.findProtection(hitEntity);
                if (protection == null) {
                    return;
                }
                Entity entity = this.getDamagerSource((Entity)e.getEntity());
                if (!(entity instanceof Player)) break block5;
                Player player = (Player)entity;
                if (this.plugin.canAccess(protection, player, "destroy")) break block6;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent e) {
        e.getAffectedEntities().removeIf(livingEntity -> {
            Protection protection = this.plugin.findProtection((Entity)livingEntity);
            if (protection == null) {
                return false;
            }
            Entity patt0$temp = this.getDamagerSource((Entity)e.getEntity());
            if (!(patt0$temp instanceof Player)) return true;
            Player player = (Player)patt0$temp;
            if (this.plugin.canAccess(protection, player, "destroy")) return false;
            return true;
        });
    }

    @EventHandler
    public void onAreaEffectCloudApply(AreaEffectCloudApplyEvent e) {
        e.getAffectedEntities().removeIf(livingEntity -> {
            Player player;
            Entity entity;
            Entity patt1$temp;
            Protection protection = this.plugin.findProtection((Entity)livingEntity);
            if (protection == null) {
                return false;
            }
            ProjectileSource patt0$temp = e.getEntity().getSource();
            return !(patt0$temp instanceof Entity) || !((patt1$temp = this.getDamagerSource(entity = (Entity)patt0$temp)) instanceof Player) || !this.plugin.canAccess(protection, player = (Player)patt1$temp, "destroy");
        });
    }

    @EventHandler
    public void onExplosionPrime(ExplosionPrimeEvent e) {
        if (this.plugin.isProtected(e.getEntity())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void entityInteract(EntityInteractEvent e) {
        if (e.getEntity() instanceof Player) {
            return;
        }
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        if (!this.plugin.canAccess(protection, ENTITY_SOURCE_RESOLVER, "entity_interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityBreakDoor(EntityBreakDoorEvent e) {
        if (e.getEntity() instanceof Player) {
            return;
        }
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        if (!this.plugin.canAccess(protection, ENTITY_SOURCE_RESOLVER, "entity_break_door")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent e) {
        block7: {
            block6: {
                if (Tag.DOORS.isTagged((Keyed)e.getBlock().getType()) && e.getTo().isAir()) {
                    return;
                }
                Protection protection = this.plugin.findProtection(e.getBlock());
                if (protection == null) {
                    return;
                }
                if (e.getEntity().getType() == EntityType.BEE && e.getBlock().getType() == e.getTo() && Tag.BEEHIVES.isTagged((Keyed)e.getTo())) {
                    return;
                }
                boolean broken = e.getTo().isAir() || e.getTo().equals((Object)Material.WATER);
                Entity entity = this.getDamagerSource(e.getEntity());
                if (!(entity instanceof Player)) break block6;
                Player player = (Player)entity;
                String[] stringArray = new String[1];
                String string = stringArray[0] = broken ? "destroy" : "interact";
                if (this.plugin.canAccess(protection, player, stringArray)) break block7;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityChangeBlockMonitor(EntityChangeBlockEvent e) {
        EntityProtection entityProtection;
        BlockProtection blockProtection;
        boolean broken = e.getTo().isAir() || e.getTo().equals((Object)Material.WATER);
        Protection findBlock = this.plugin.findProtection(e.getBlock());
        if (findBlock instanceof BlockProtection) {
            blockProtection = (BlockProtection)findBlock;
            if (e.getEntity() instanceof Player && !broken && blockProtection.getBlock().equals(e.getBlock().getType().name()) && e.getBlock().getType() != e.getTo()) {
                blockProtection.setBlock(e.getTo().name());
                this.plugin.saveProtection(blockProtection);
            }
        }
        if ((blockProtection = this.plugin.loadProtection(e.getBlock())) != null && broken && e.getEntity() instanceof Player) {
            if (COPPER_GOLEM_STATUES != null && COPPER_GOLEM_STATUES.isTagged((Keyed)e.getBlock().getType())) {
                BlockLocation location = BlockLocation.fromProtection(blockProtection);
                this.reanimatedCopperGolems.put(location, blockProtection);
                SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)e.getEntity(), () -> this.reanimatedCopperGolems.remove(location));
            }
            this.plugin.removeProtection(blockProtection);
        }
        if ((entityProtection = this.plugin.loadProtection(e.getEntity())) != null && e.getEntity().getType() == COPPER_GOLEM && COPPER_GOLEM_STATUES != null && COPPER_GOLEM_STATUES.isTagged((Keyed)e.getTo())) {
            BlockProtection newProtection = this.plugin.createProtection(e.getBlock(), entityProtection.getOwner(), entityProtection.getType());
            newProtection.setBlock(e.getTo().name());
            newProtection.setAccess(entityProtection.getAccess());
            this.plugin.saveProtection(newProtection);
            this.plugin.removeProtection(entityProtection);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onItemTransportingEntityValidateTarget(Entity entity, Block block, Consumer<Boolean> setAllowed) {
        SourceResolver resolver;
        Protection blockProtection = this.plugin.findProtection(block);
        if (blockProtection == null) {
            return;
        }
        Protection entityProtection = this.plugin.findProtection(entity);
        SourceResolver sourceResolver = resolver = entityProtection != null ? new BukkitPlayerResolver(this.plugin.getBolt(), entityProtection.getOwner()) : ENTITY_SOURCE_RESOLVER;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getType() == COPPER_GOLEM) {
                boolean isPickingUpItem = Objects.requireNonNull(livingEntity.getEquipment()).getItemInMainHand().getAmount() == 0;
                String permission = isPickingUpItem ? "withdraw" : "deposit";
                if (this.plugin.canAccess(blockProtection, resolver, permission)) return;
                setAllowed.accept(false);
                return;
            }
        }
        if (this.plugin.canAccess(blockProtection, resolver, "withdraw", "deposit")) return;
        setAllowed.accept(false);
    }

    private Entity getDamagerSource(Entity damager) {
        Projectile projectile;
        ProjectileSource projectileSource;
        if (damager instanceof Projectile && (projectileSource = (projectile = (Projectile)damager).getShooter()) instanceof Entity) {
            Entity source = (Entity)projectileSource;
            return source;
        }
        return damager;
    }
}

